<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Models\Report;
use DateTime;

class HomeController extends Controller
{
    public function index(Request $request)
    {
      // ◆◆◆検査用メニュー遷移：元の処理◆◆◆
      // index() // まぁ・・別にRequestを受け取っていてもいいと思うけど
      // ◆◆◆検査用メニュー遷移：ココから◆◆◆
      // モバイル以外の場合は例のメニューをリターンする
      // $isMobile = false;
      // $user_agent =  $request->header('User-Agent');
      // if ((strpos($user_agent, 'iPhone') !== false)
      //     || (strpos($user_agent, 'Android') !== false)) {
      //     $isMobile = true;
      // }
      // if (!$isMobile) {
      //   return view('_menu/index');
      // }
      // ◆◆◆検査用メニュー遷移：ココまで◆◆◆

      // チェックポイント保存（Homeはどこへも行けるため全てのチェックポイントを保存する）
      session(['checkpoint' => url()->full()]);
      session(['checkpoint-second' => url()->full()]);

      // 「今日」とする範囲を始業時間から算出する
      $work_start_time = new DateTime('09:00:00');  // 始業時間指定
      $current_time = New DateTime(date('H:i:s'));
      if ($current_time < $work_start_time) {
        // 始業時間前のため1日前を参照する
        $today = date('Y-m-d', strtotime('-1 day'));
      } else {
        // 始業時間後のため今日を参照する
        $today = date('Y-m-d');
      }

      // DBよりReportテーブルの値を検索
      $reportQuery = Report::query();
      $reportQuery = $reportQuery->where('user_id', '=', Auth::user()->id);
      $reportQuery = $reportQuery->whereDate('start_at', '=', $today);
      $reports = $reportQuery;

      return view('home/index')
      ->with([
          'reports' => $reports,
          'work_start_time' => $work_start_time->format('G時i分'),
      ]);
    }
}
