<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\ReportRestRequest;
use App\Models\Report;
use App\Models\ReportRest;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Common\SendErrorMessage;

class ReportRestController extends Controller
{
  public function index(Request $request, $reportId)
    {
        // チェックポイント保存
        session(['checkpoint-second' => url()->full()]);

        // パラメータ取得
        $params = $request->all();

        // パラメータ初期値
        if (empty($params['sort'])) {
          $params['sort'] = 'id';
          $params['direction'] = 'asc';
        }

        // ページネーション設定
        // $page_max = config('const.DEFAULT_PAGE_MAX');
        $page_max = 10;

        // クエリ成形
        $report_restQuery = ReportRest::query();
        $report_restQuery = $report_restQuery->where('report_id', '=', $reportId);

        // DBよりReportRestテーブルの値を検索
        $report_rests = $report_restQuery
            ->orderBy($params['sort'], $params['direction'])
            ->paginate($page_max);

        // DBよりURIパラメータと同じreportIdを持つReportの情報を取得
        $report = Report::findOrFail($reportId);
            
        // 取得した値をビュー「report/rest/index」に渡す
        return view('report/rest/index')
            ->with([
                'report_rests' => $report_rests,
                'params' => $params,
                'report' => $report,
            ]);
    }

    public function create($reportId)
    {
        // 空の$report_restを渡す
        $report_rest = new ReportRest();

        // DBよりURIパラメータと同じreportIdを持つReportの情報を取得
        $report = Report::findOrFail($reportId);

        return view('report/rest/create', compact('report_rest', 'report'));
    }
    
    public function store(ReportRestRequest $request, $reportId)
    {
        // エラーメッセージ
        $error_messages = [];
        if (!empty($error_messages)) {
          return SendErrorMessage::validationException($request, $error_messages);
        }

        $report_rest = new ReportRest();
        $report_rest->report_id = $reportId;
        $report_rest->point = $request->point;
        $report_rest->start_at = $request->start_at;
        $report_rest->end_at = $request->end_at;
        $report_rest->save();
    
        return redirect(session()->get('checkpoint-second') ?? './');
    }

    public function edit($reportId, $restId)
    {
        // DBよりURIパラメータと同じIDを持つReportの情報を取得
        $report_rest = ReportRest::findOrFail($restId);

        // DBよりURIパラメータと同じreportIdを持つReportの情報を取得
        $report = Report::findOrFail($reportId);

        // 取得した値をビュー「report/rest/edit」に渡す
        return view('report/rest/edit', compact('report_rest', 'report'));
    }

    public function update(ReportRestRequest $request, $reportId, $restId)
    {
        // エラーメッセージ
        $error_messages = [];
        if (!empty($error_messages)) {
          return SendErrorMessage::validationException($request, $error_messages);
        }

        $report_rest = ReportRest::findOrFail($restId);
        $report_rest->report_id = $reportId;
        $report_rest->point = $request->point;
        $report_rest->start_at = $request->start_at;
        $report_rest->end_at = $request->end_at;
        $report_rest->save();

        return redirect(session()->get('checkpoint-second') ?? './');
    }

    public function destroy(Request $request, $reportId, $restId)
    {
        // エラーメッセージ
        $error_messages = [];
        if (!empty($error_messages)) {
          return SendErrorMessage::validationException($request, $error_messages);
        }

        $report_rest = ReportRest::findOrFail($restId);
        $report_rest->delete();
    
        return redirect(session()->get('checkpoint-second') ?? './');
    }

}
