<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\ReportRequest;
use App\Models\Report;
use App\Models\User;
use App\Models\Car;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Common\SendErrorMessage;

class WorkController extends Controller
{
    public function index(Request $request)
    {
        // チェックポイント保存
        session(['checkpoint' => url()->full()]);
        // チェックポイント保存（明細編集画面へのショートカットがあるためセカンドも保存。明細一覧に行けばそっちでセカンドが上書きされる）
        session(['checkpoint-second' => url()->full()]);

        // パラメータ取得
        $params = $request->all();

        // パラメータ初期値
        if (empty($params['sort'])) {
          $params['sort'] = 'start_at';
          $params['direction'] = 'desc';
        }
        if (empty($params['start_at'])) {
          $params['start_at'] = date('Y-m-d', strtotime('today'));
        }

        // メインレイアウトの検索バーを活性化させるため検索ワードを指定
        // $targets = [
        //   \Lang::get('db.report.note'),
        // ];
        // $target = implode(', ', $targets);
        // $search_target = \Lang::get('system.placeholder.search_target', ['target' => $target]);
        $search_target = '';

        // ページネーション設定
        // $page_max = config('const.DEFAULT_PAGE_MAX');
        $page_max = 10;

        // クエリ成形
        $reportQuery = Report::query();
        $reportQuery = $reportQuery->whereYear('start_at', '=', date('Y', strtotime($params['start_at'])));
        $reportQuery = $reportQuery->whereMonth('start_at', '=', date('m', strtotime($params['start_at'])));
        $reportQuery = $reportQuery->whereDay('start_at', '=', date('d', strtotime($params['start_at'])));
        if (!empty($params['search'])) {
          $reportQuery = $reportQuery->where('note', 'like', '%'.$params['search'].'%');
        }

        // DBよりReportテーブルの値を検索
        $reports = $reportQuery
            ->orderBy($params['sort'], $params['direction'])
            ->paginate($page_max);

        // セレクトボックス用にUsersを取得
        $users = User::get();

        // 取得した値をビュー「work/index」に渡す
        return view('work/index')
            ->with([
                'reports' => $reports,
                'search_target' => $search_target,
                'params' => $params,
                'users' => $users,
            ]);
    }

}
