<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class RegenerateToken
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        if ($request->method() === 'POST'){
            // POSTのときだけトークンリフレッシュをしformの多重送信を防ぐ
            $request->session()->regenerateToken();
          }
        
          return $next($request);
    }
}
