<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class BillingRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
          'name' => 'required|string|max:50',
          'zip_code' => 'required|string|max:10',
          'address_1' => 'nullable|string|max:100',
          'address_2' => 'nullable|string|max:100',
          'phone_number' => 'required|string|max:20',
          'person_in_charge' => 'nullable|string|max:50',
          'note' => 'nullable|string|max:200',
        ];
    }

    public function attributes()
    {
        return [
          'name' => \Lang::get('db.billing.name'),
          'zip_code' => \Lang::get('db.billing.zip_code'),
          'address_1' => \Lang::get('db.billing.address_1'),
          'address_2' => \Lang::get('db.billing.address_2'),
          'phone_number' => \Lang::get('db.billing.phone_number'),
          'person_in_charge' => \Lang::get('db.billing.person_in_charge'),
          'note' => \Lang::get('db.billing.note'),
        ];
    }
}
