<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CarRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
          'name' => 'required|string|max:50',
          'format' => 'nullable|string|max:50',
          'size' => 'nullable|string|max:50',
          'number' => 'required|string|max:50',
          'capacity' => 'nullable|integer|max:9999999',
          'use' => 'required|integer',
          'maker' => 'nullable|string|max:50',
          'inspection_at' => 'nullable|date',
          'inspection_next_at' => 'nullable|date',
          'note' => 'nullable|string|max:200',
        ];
    }

    public function attributes()
    {
        return [
          'name' => \Lang::get('db.car.name'),
          'format' => \Lang::get('db.car.format'),
          'size' => \Lang::get('db.car.size'),
          'number' => \Lang::get('db.car.number'),
          'capacity' => \Lang::get('db.car.capacity'),
          'use' => \Lang::get('db.car.use'),
          'maker' => \Lang::get('db.car.maker'),
          'inspection_at' => \Lang::get('db.car.inspection_at'),
          'inspection_next_at' => \Lang::get('db.car.inspection_next_at'),
          'note' => \Lang::get('db.car.note'),
        ];
    }
}
