<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ExampleRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
      return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
          'name' => 'required|string|max:50',
          'price' => 'required|integer',
          'author' => 'nullable|string|max:50',
        ];
    }

    public function attributes()
    {
        return [
          'name' => \Lang::get('db.example.name'),
          'price' => \Lang::get('db.example.price'),
          'author' => \Lang::get('db.example.author'),
        ];
    }
}
