<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ItemRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
          'name' => 'required|string|max:50',
          'note' => 'nullable|string|max:200',
        ];
    }

    public function attributes()
    {
        return [
          'name' => \Lang::get('db.item.name'),
          'note' => \Lang::get('db.item.note'),
        ];
    }
}
