<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class PartnerRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
          'name' => 'required|string|max:50',
          'company_name' => 'required|string|max:50',
          'quantity' => 'nullable|integer|max:999',
          'note' => 'nullable|string|max:200',
        ];
    }

    public function attributes()
    {
        return [
          'name' => \Lang::get('db.partner.name'),
          'company_name' => \Lang::get('db.partner.company_name'),
          'quantity' => \Lang::get('db.partner.quantity'),
          'note' => \Lang::get('db.partner.note'),
        ];
    }
}
