<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class ReportPartnerRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
          'partner_id' => 'required|integer',
          'quantity' => 'required|integer|min:1|max:99',
          'car_number' => 'nullable|string|max:50',
          'item_name' => 'nullable|string|max:50',
          'count' => 'nullable|integer|max:999',
          'take_down' => 'nullable|string|max:50',
        ];
    }

    public function attributes()
    {
        return [
          'partner_id' => \Lang::get('db.report_partner.partner_id'),
          'quantity' => \Lang::get('db.report_partner.quantity'),
          'car_number' => \Lang::get('db.report_partner.car_number'),
          'item_name' => \Lang::get('db.report_partner.item_name'),
          'count' => \Lang::get('db.report_partner.count'),
          'take_down' => \Lang::get('db.report_partner.take_down'),
        ];
    }
}
