<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class ReportRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
          'user_id' => 'required|integer',
          'car_id' => 'required|integer',
          'start_at' => 'required|date',
          'end_at' => 'nullable|date',
          'start_point' => 'nullable|string|max:50',
          'end_point' => 'nullable|string|max:50',
          'start_meter' => 'nullable|integer|max:9999999',
          'end_meter' => 'nullable|integer|max:9999999',
          'light_oil' => 'nullable|integer|max:9999999',
          'adblue' => 'nullable|integer|max:9999999',
          'adblue_handy' => 'nullable|integer|max:9999999',
          'alcohol_check' => 'nullable|integer',
          'note' => 'nullable|string|max:200',
        ];
    }

    public function attributes()
    {
        return [
          'user_id' => \Lang::get('db.report.user_id'),
          'car_id' => \Lang::get('db.report.car_id'),
          'start_at' => \Lang::get('db.report.start_at'),
          'end_at' => \Lang::get('db.report.end_at'),
          'start_point' => \Lang::get('db.report.start_point'),
          'end_point' => \Lang::get('db.report.end_point'),
          'start_meter' => \Lang::get('db.report.start_meter'),
          'light_oil' => \Lang::get('db.report.light_oil'),
          'adblue' => \Lang::get('db.report.adblue'),
          'adblue_handy' => \Lang::get('db.report.adblue_handy'),
          'alcohol_check' => \Lang::get('db.report.alcohol_check'),
          'note' => \Lang::get('db.report.note'),
        ];
    }
}
