<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class ReportRestRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
          'point' => 'required|string|max:50',
          'start_at' => 'required|date',
          'end_at' => 'nullable|date',
        ];
    }

    public function attributes()
    {
        return [
          'point' => \Lang::get('db.report_rest.point'),
          'start_at' => \Lang::get('db.report_rest.start_at'),
          'end_at' => \Lang::get('db.report_rest.end_at'),
        ];
    }
}
