<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class ReportWaypointRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
          'take_up' => 'required|string|max:50',
          'take_down' => 'nullable|string|max:50',
          'item_name' => 'nullable|string|max:50',
          'quantity' => 'nullable|numeric|max:99999999.99|required_with:unit,unit_price',
          'unit' => 'nullable|integer|max:9|required_with:quantity,unit_price',
          'unit_price' => 'nullable|integer|max:99999999|required_with:quantity,unit',
          'type_id' => 'required|integer',
          'billing_id' => 'required|integer',
          'billing_disposal_name' => 'nullable|string|max:50',
          'highway_money' => 'nullable|integer|max:9999999',
          'highway_payment' => 'nullable|required_unless:highway_money,null|integer|max:9',
          'emergency' => 'nullable|integer|max:9',
          'address' => 'nullable|string|max:100',
          'note' => 'nullable|string|max:200',
        ];
    }

    public function attributes()
    {
        return [
          'take_up' => \Lang::get('db.report_waypoint.take_up'),
          'take_down' => \Lang::get('db.report_waypoint.take_down'),
          'item_name' => \Lang::get('db.report_waypoint.item_name'),
          'quantity' => \Lang::get('db.report_waypoint.quantity'),
          'unit' => \Lang::get('db.report_waypoint.unit'),
          'unit_price' => \Lang::get('db.report_waypoint.unit_price'),
          'type_id' => \Lang::get('db.report_waypoint.type_id'),
          'billing_id' => \Lang::get('db.report_waypoint.billing_id'),
          'billing_disposal_name' => \Lang::get('db.report_waypoint.billing_disposal_name'),
          'highway_money' => \Lang::get('db.report_waypoint.highway_money'),
          'highway_payment' => \Lang::get('db.report_waypoint.highway_payment'),
          'emergency' => \Lang::get('db.report_waypoint.emergency'),
          'address' => \Lang::get('db.report_waypoint.address'),
          'note' => \Lang::get('db.report_waypoint.note'),
        ];
    }
}
