<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Report extends Model
{
    public function waypoints()
    {
        return $this->hasMany(ReportWaypoint::class);
    }

    public function rests()
    {
        return $this->hasMany(ReportRest::class);
    }

    public function partners()
    {
        return $this->hasMany(ReportPartner::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class)->withTrashed();
    }

    public function car()
    {
        return $this->belongsTo(Car::class)->withTrashed();
    }

}
