<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

class CarFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
          'number' => $this->faker->randomElement(['名古屋','尾張小牧','三河','豊橋','岡崎','豊田','一宮','春井'])
            .$this->faker->numberBetween(900,999)
            .$this->faker->randomElement(['あ','い','う','え','か','き','く','け','こ','を'])
            .sprintf('%02d', $this->faker->numberBetween(0,99)).'-'.sprintf('%02d', $this->faker->numberBetween(0,99)),
          'use' => $this->faker->numberBetween(0,1),
          'maker' => $this->faker->randomElement(['トヨタ','ホンダ','スズキ','ダイハツ','日産','マツダ','スバル','三菱','ISUZU']),
          'name' => $this->faker->lastKanaName(),
          //'note' => $this->faker->realText(),
        ];
    }
}
