<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Hash;

class UserFactory extends Factory
{
    private static int $sequence = 1;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
          'account' => 'staff'.sprintf('%03d', self::$sequence++),
          'password' => Hash::make('test'),
          'name' => $this->faker->name(),
          'car_id' => $this->faker->numberBetween(0,10),
        ];
    }
}
