<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCarsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cars', function (Blueprint $table) {
            $table->id();
            $table->string('name', 50);
            $table->string('format', 50)->nullable();
            $table->string('size', 50)->nullable();
            $table->string('number', 50);
            $table->integer('capacity')->nullable();
            $table->integer('use')->length(1);
            $table->string('maker', 50)->nullable();
            $table->date('inspection_at')->nullable();
            $table->date('inspection_next_at')->nullable();
            $table->string('note', 200)->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cars');
    }
}
