<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateReportsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('reports', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id');
            $table->foreignId('car_id');
            $table->dateTime('start_at', $precision = 0)->nullable();
            $table->dateTime('end_at', $precision = 0)->nullable();
            $table->string('start_point', 50)->nullable();
            $table->string('end_point', 50)->nullable();
            $table->integer('start_meter')->nullable();
            $table->integer('end_meter')->nullable();
            $table->integer('light_oil')->nullable();
            $table->integer('adblue')->nullable();
            $table->integer('adblue_handy')->nullable();
            $table->integer('alcohol_check')->length(1)->nullable();
            $table->string('note', 200)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('reports');
    }
}
