<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateReportWaypointsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('report_waypoints', function (Blueprint $table) {
            $table->id();
            $table->foreignId('report_id');
            $table->string('take_up', 50);
            $table->string('take_down', 50)->nullable();
            $table->string('item_name', 50)->nullable();
            $table->float('quantity', 8, 2)->nullable();
            $table->integer('unit')->length(1)->nullable();
            $table->integer('unit_price')->nullable();
            $table->foreignId('type_id')->nullable();
            $table->foreignId('billing_id')->nullable();
            $table->string('billing_disposal_name', 50)->nullable();
            $table->integer('highway_money')->nullable();
            $table->integer('highway_payment')->length(1)->nullable();
            $table->integer('emergency')->length(1)->nullable();
            $table->string('address', 100)->nullable();
            $table->string('note', 200)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('report_waypoints');
    }
}
