<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateReportPartnersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('report_partners', function (Blueprint $table) {
            $table->id();
            $table->foreignId('report_id');
            $table->foreignId('partner_id');
            $table->integer('quantity')->nullable();
            $table->string('car_number', 50)->nullable();
            $table->string('item_name', 50)->nullable();
            $table->integer('count')->nullable();
            $table->string('take_down', 50)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('report_partners');
    }
}
