<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ExamplesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
	public function run()
	{
	    // テーブルのクリア
	    DB::table('examples')->truncate();

	    // 初期データ用意（列名をキーとする連想配列）
	    $examples = [
	              ['name' => 'PHP Example',
	               'price' => 2000,
	               'author' => 'PHPER'],
	              ['name' => 'Laravel Example',
	               'price' => 3000,
	               'author' => null],
	              ['name' => 'Ruby Example',
	               'price' => 2500,
	               'author' => 'Rubyist']
	             ];

	    // 登録
	    foreach($examples as $example) {
            \App\Models\Example::create($example);
	    }
	}
}
