<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class TypesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
	    // テーブルのクリア
	    DB::table('types')->truncate();

	    // 初期データ用意（列名をキーとする連想配列）
	    $types = [
	              [
                  'name' => '常用',
	                'note' => '',
                ],
	              [
                  'name' => '回送',
	                'note' => '',
                ],
	              [
                  'name' => '処分',
	                'note' => '',
                ],
	              [
                  'name' => '１車取',
	                'note' => '',
                ],
	              [
                  'name' => 'コンテナ設置',
	                'note' => '',
                ],
	              [
                  'name' => '引上げ',
	                'note' => '',
                ]
              ];

	    // 登録
	    foreach($types as $type) {
            \App\Models\Type::create($type);
	    }
    }
}
