<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class UsersTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
	    // テーブルのクリア
	    DB::table('users')->truncate();

      // 固定の初期データ用意（列名をキーとする連想配列）
      // ファクトリー側のaccountはstaff***の連番で作成される
	    $users = [
	              [
                  'name' => '宮川 翔多',
	                'account' => 'admin',
	                'password' => Hash::make('M4tfxb'),
                ]
              ];

	    // 登録
	    foreach($users as $user) {
            \App\Models\User::create($user);
	    }

      // ファクトリーによるランダムテストデータ生成
      // User::factory()->count(20)->create();

    }
}
