let inParams = [];

/**
 * テーブルリストのソートボタンを対象クラスにセットする
 */
function setSortButton() {
  // ボタンを生成する対象を取得
  let elements = document.getElementsByClassName('sort_button');
  let len = elements.length;
  // 初期化
  let sort = '';
  let button = null;

  for (let i = 0; i < len; i++){
    // ソート名
    sort = elements.item(i).dataset.sort;

    // DESC用ボタンセット
    button = getSortButton(inParams['sort'], inParams['direction'], sort, 'desc');
    if (button !== false) {
      elements.item(i).appendChild(button);
    }

    // ASC用ボタンセット
    button = getSortButton(inParams['sort'], inParams['direction'], sort, 'asc');
    if (button !== false) {
      elements.item(i).appendChild(button);
    }

  }
}

/**
 * ソートボタンを取得する
 * @param  {string} current_sort 現在のソート
 * @param  {string} current_direction 現在の昇順/降順
 * @param  {string} target_sort 生成するボタンのソート
 * @param  {string} target_direction 生成するボタンの昇順/降順
 * @return {element} 生成に成功した場合はエレメントを、失敗した場合はfalseを返す
 */
function getSortButton(current_sort, current_direction, target_sort, target_direction) {
  let el_link = document.createElement('a');
  let el_button = document.createElement('span');

  // ボタン用リクエストURLセット
  let requests = {
    sort: target_sort,
    direction: target_direction,
  }
  let url = getRequestUrl(requests);
  if (!url) return false;

  // 現在のソートとの同一チェック
  if (current_sort === target_sort && current_direction === target_direction) {
    // 現在のソート
    el_button.classList.add('text-warning');
  } else {
    // 現在のソート以外
    el_button.classList.add('text-secondary');
    el_link.href = url;
  }

  // アイコン判定
  if (target_direction === 'asc') {
    el_button.classList.add('bi', 'bi-sort-down-alt', 'me-0');
  } else {
    el_button.classList.add('bi', 'bi-sort-down', 'me-1');
  }

  // リンクにボタンを埋め込む
  el_link.appendChild(el_button);

  return el_link;
}

/**
 * DBリクエストのURLを取得する
 * @param {object} requests DBリクエストのパラメータ（連想配列）
 * @return {boolean} 生成に成功した場合はURLを、失敗した場合はfalseを返す
 */
function getRequestUrl(requests) {
  // 現在のURLSearchParamsオブジェクトを取得
  let url = new URL(window.location.href);  // 現在のフルパス
  let params = url.searchParams;            // 現在のパラメータ
  let return_url = location.pathname;       // 現在のパスを返却URLとして控える

  if (!requests || typeof requests !== 'object') return false;

  // 新規リクエストでクリアすべきパラメータを削除する
  params.delete('page');  // 再読み込みによりページ番号は初期化される

  // 指定されたパラメータを生成する
  for (var key in requests) {
    // 重複する既存パラメータを削除する
    params.delete(key);

    if (!requests[key]) {
      // 中身が無ければ削除だけを行う
      continue;
    }

    // 新規パラメータを生成する
    params.append(key, requests[key]);
  }

  // パラメータが有る場合は返却URLに付与する
  if (params.toString().length > 0) {
    return_url = return_url + '?' + params;
  }

  return return_url;
}

