<?php

return [

  /*
  |--------------------------------------------------------------------------
  | DB
  |--------------------------------------------------------------------------
  |
  | DBの各テーブルとそのカラム名をそれぞれ定義する。
  | langを用意しない場合はdb.table.columnがそのまま表示される形となる。（海外開発用）
  | selectに対するselect-0,select-1で「なし」「あり」とする場合もここで定義する。
  |
  */

  'examples' => '例',
  'example' => [
    'id' => '例ID',
    'name' => '例名',
    'price' => '価格',
    'author' => '作者',
  ],

  'users' => '社員マスタ',
  'user' => [
    'id' => '社員ID',
    'account' => 'アカウント',
    'password' => 'パスワード',
    'password_confirmation' => 'パスワード（確認）',
    'name' => '社員名',
    'car_id' => '車両番号',
    'phone_number' => '携帯番号',
    'email' => 'メールアドレス',
  ],
    
  'cars' => '車両マスタ',
  'car' => [
    'id' => '車両ID',
    'name' => '車両名称',
    'format' => '形式',
    'size' => '寸法',
    'number' => '車番',
    'capacity' => '最大積載量',
    'use' => '利用状況',
    'use-0' => '利用停止（車検等）',
    'use-1' => '利用中',
    'maker' => 'メーカー',
    'inspection_at' => '車検日付',
    'inspection_next_at' => '次回車検月',
    'note' => 'その他備考',
  ],
  
  'items' => '品目マスタ',
  'item' => [
    'id' => '品目ID',
    'name' => '品目名',
    'note' => '備考',
  ],

  'types' => '区分マスタ',
  'type' => [
    'id' => '区分ID',
    'name' => '区分名',
    'note' => '備考',
  ],

  'billings' => '請求先マスタ',
  'billing' => [
    'id' => '請求先ID',
    'name' => '請求先名',
    'address' => '住所',
    'zip_code' => '郵便番号',
    'address_1' => '住所1',
    'address_2' => '住所2（建物名等）',
    'phone_number' => '電話番号',
    'person_in_charge' => '担当者',
    'note' => '備考',
  ],

  'partners' => '同行車マスタ',
  'partner' => [
    'id' => '同行車ID',
    'name' => '同行車（傭車）',
    'company_name' => '会社名',
    'quantity' => '基本台数',
    'note' => '備考',
  ],

  'reports' => '運転日報',
  'report' => [
    'id' => '日報ID',
    'user_id' => '運転者氏名',
    'car_id' => '車番',
    'start_at' => '開始日時',
    'end_at' => '終了日時',
    'start_point' => '開始地点',
    'end_point' => '終了地点',
    'start_meter' => '開始メーター',
    'end_meter' => '終了メーター',
    'milage' => '差引走行距離',
    'light_oil' => '軽油',
    'adblue' => 'アドブルー',
    'adblue_handy' => 'ABハンディ',
    'alcohol_check' => 'アルコールチェック',
    'alcohol_check-0' => 'アルコールチェック未実施',
    'alcohol_check-1' => 'アルコールチェック済',
    'note' => '備考',
    'start' => '乗務開始',
    'end' => '乗務終了',
    'oil' => '燃料給油',
    'other' => 'その他',
  ],

  'report_waypoints' => '主な経路地',
  'report_waypoints_short' => '経路',
  'report_waypoint' => [
    'id' => '経路地ID',
    'report_id' => '日報ID',
    'take_up' => '品名（１行目）',
    'take_down' => '品名（２行目）',
    'item_name' => '品目',
    'quantity' => '重量(数量)',
    'unit' => '単位',
    'unit_price' => '単価',
    'type_id' => '区分',
    'billing_id' => '請求先',
    'billing_disposal_name' => '請求先(処分)',
    'highway_money' => '高速代',
    'highway_payment' => '支払い',
    'emergency' => '緊急配車',
    'emergency-1' => 'この経路を緊急に指定',
    'address' => '住所',
    'note' => '社内メモ',
  ],

  'report_rests' => '休憩・仮眠の地点',
  'report_rests_short' => '休憩',
  'report_rest' => [
    'id' => '休憩ID',
    'point' => '場所',
    'start_at' => '開始日時',
    'end_at' => '終了日時',
  ],

  'report_partners' => '同行車',
  'report_partners_short' => '同行',
  'report_partner' => [
    'id' => '同行車ID',
    'partner_id' => '同行者（備車）',
    'company_name' => '会社名',
    'quantity' => '台数',
    'car_number' => '車番',
    'item_name' => '品目',
    'count' => '回数',
    'take_down' => '卸地',
  ],

//  'csv_billing' => '請求書CSV', // ◆◆◆検査対応◆◆◆
  // 'csv_billing' => '請求書',
  'pdf_billing' => '請求書',

  'works' => '配車',

];
