<div class="container-fluid px-0">
  <div class="row text-center mb-3">
    <div class="col">
      @if($target == 'store')
      <h1 class="h2">@lang('db.users') @lang('system.title.create')</h1>
      @elseif($target == 'update')
      <h1 class="h2">@lang('db.users') @lang('system.title.edit')</h1>
      @endif
    </div>
  </div>
  @if($target == 'store')
  <form action="/user" method="post" onsubmit="return submitForm()">
  @elseif($target == 'update')
  <form action="/user/{{ $user->id }}" name="" method="post" onsubmit="return submitForm()">
    <input type="hidden" name="_method" value="PUT">
  @endif
    @csrf
    <div class="row justify-content-center">
      <div class="col-12 col-md-8 col-lg-6">{{-- Set Input Form Size --}}
        @include('common/error-message')
        <div class="card border-secondary mb-3 w-100">
          <div class="card-header mb-2">@lang('db.users') @lang('system.title.information')</div>
          <div class="card-body">
            <div class="form-group mb-4">
              <label class="form-label mb-2">@lang('db.user.name')</label>
              <input type="text" class="form-control @error('name') is-invalid @enderror" name="name" placeholder="" value="{{ old('name', $user->name) }}">
              @error('name')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
            </div>
            <div class="form-group mb-4">
              <label class="form-label mb-2">@lang('db.user.car_id')</label>
              <select class="form-select @error('car_id') is-invalid @enderror" name="car_id">
                <option value=""></option>
                @foreach ($cars as $car)
                <option value="{{ $car->id }}" @if(old('car_id', $user->car_id)==$car->id) selected  @endif>{{ $car->number }}【@lang('db.car.use-'.$car->use)】</option>
                @endforeach
              </select>
              <div class="form-text">@lang('db.reports')の初期選択として使用されます</div>
              @error('car_id')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
            </div>            
            <div class="form-group mb-4">
              <label class="form-label mb-2">@lang('db.user.phone_number')</label>
              <input type="text" class="form-control @error('phone_number') is-invalid @enderror" name="phone_number" placeholder="" value="{{ old('phone_number', $user->phone_number) }}">
              @error('phone_number')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
            </div>
            <div class="form-group mb-4">
              <label class="form-label mb-2">@lang('db.user.email')</label>
              <input type="email" class="form-control @error('email') is-invalid @enderror" name="email" placeholder="" value="{{ old('email', $user->email) }}">
              @error('email')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
            </div>
            <div class="form-group mb-4">
              <label class="form-label mb-2">@lang('db.user.account')</label>
              <input type="text" class="form-control @error('account') is-invalid @enderror" name="account" placeholder="" value="{{ old('account', $user->account) }}" @if($user->id == 1) readonly @endif>
              @error('account')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
            </div>
            @if($target == 'store')
            <div class="form-group mb-4">
              <label class="form-label mb-2">@lang('db.user.password')</label>
              <input type="password" id="password" class="form-control @error('password') is-invalid @enderror" name="password" placeholder="" value="{{ old('password') }}" autocomplete="new-password">
              @error('password')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
            </div>
            <div class="form-group mb-4">
              <label class="form-label mb-2">@lang('db.user.password_confirmation')</label>
              <input type="password" id="password_confirmation" class="form-control @error('password_confirmation') is-invalid @enderror" name="password_confirmation" placeholder="" value="">
              @error('password_confirmation')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
            </div>
            @endif
          </div>
        </div>
        @if($target == 'update')
        <div class="card border-secondary mb-3 w-100">
          <div class="card-header mb-2">@lang('db.user.password') @lang('system.title.information')</div>
          <div class="card-body">
            <div class="form-group mb-4">
              <label class="form-check-label">
                <input type="checkbox" id="password_change" class="form-check-input" name="password_change" value="1" @if(old('password_change') == '1') checked @endif>
                @lang('system.command.change')
              </label>
            </div>
            <div class="form-group mb-4">
              <label class="form-label mb-2">@lang('db.user.password')</label>
              <input type="password" id="password" class="form-control @error('password') is-invalid @enderror" name="password" placeholder="" value="{{ old('password') }}" @if(old('password_change') != '1') disabled @endif autocomplete="new-password">
              @error('password')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
            </div>
            <div class="form-group mb-4">
              <label class="form-label mb-2">@lang('db.user.password_confirmation')</label>
              <input type="password" id="password_confirmation" class="form-control @error('password_confirmation') is-invalid @enderror" name="password_confirmation" placeholder="" value="" @if(old('password_change') != '1') disabled @endif>
              @error('password_confirmation')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
            </div>
          </div>
        </div>
        @endif

      </div>
    </div>
    <div class="row justify-content-center mb-4">
      <div class="col-12 col-md-5 col-lg-4 mt-2 mb-2">{{-- Not Change --}}
        <button type="submit" id="submit-button" class="btn btn-primary w-100"><span class="bi bi-check-circle me-2"></span>@lang('system.command.register')</button>
      </div>
      <div class="col-12 col-md-3 col-lg-2 mt-2 mb-2">
        @if (session()->has('checkpoint'))
        <a href="{{ session()->get('checkpoint') }}" class="btn btn-outline-primary w-100"><span class="bi bi-caret-left me-1"></span>@lang('system.command.back')</a>
        @else
        <a href="./" class="btn btn-outline-primary w-100"><span class="bi bi-caret-left me-1"></span>@lang('system.command.back')</a>
        @endif
      </div>
    </div>
  </form>
</div>
@if($target == 'update')
<script>
  window.addEventListener('load', function() {
    document.getElementById('password_change').addEventListener('change', function() {
      const password = document.getElementById('password');
      const password_confirmation = document.getElementById('password_confirmation');
      if (this.checked) {
        password.disabled = false;
        password_confirmation.disabled = false;
      } else {
        password.disabled = true;
        password_confirmation.disabled = true;
      }
      return;
    }, false);
  }, false);
</script>
@endif
@include('common/script-form')
