@extends('common/main/layout')
@section('content')
<div class="container-fluid px-0">
  <div class="row mb-3">
    <div class="col">
      <h1 class="h2">@lang('db.users') @lang('system.title.index')</h1>
    </div>
  </div>
  @include('common/error-message')
  <div class="row">
    <div class="col">
      <a href="/user/create" class="btn btn-primary m-2"><span class="bi bi-plus-square me-2"></span>@lang('system.command.create')</a>
    </div>
  </div>
  <div class="row">
    <div class="col">
      <div class="table-responsive">
        <table class="table table-hover text-nowrap">
          <thead>
            <tr>
              <th class="text-center tb-col-icon-button">@lang('system.command.edit')</th>
              <th class="text-center tb-col-id">@lang('db.user.id')<span class="sort_button ms-2" data-sort="id"></span</th>
              <th class="text-start">@lang('db.user.name')<span class="sort_button ms-2" data-sort="name"></span></th>
              <th class="text-start">@lang('db.user.account')<span class="sort_button ms-2" data-sort="account"></span></th>
              <th class="text-start">@lang('db.user.phone_number')<span class="sort_button ms-2" data-sort="phone_number"></span></th>
              <th class="text-start">@lang('db.user.email')<span class="sort_button ms-2" data-sort="email"></span></th>
              <th class="text-center tb-col-icon-button">@lang('system.command.delete')</th>
            </tr>
          </thead>
          <tbody>
            @foreach($users as $user)
            <tr>
              <td class="text-center tb-col-icon-button">
                <a href="/user/{{ $user->id }}/edit" class="btn btn-xs btn-success"><span class="bi bi-pencil-fill"></span></a>
              </td>
              <td class="text-center tb-col-id">{{ $user->id }}</td>
              <td class="text-start">{{ $user->name }}</td>
              <td class="text-start">{{ $user->account }}</td>
              <td class="text-start">@if (!empty($user->phone_number))<a href="tel:{{ $user->phone_number }}">{{ $user->phone_number }}</a>@endif</td>
              <td class="text-start">@if (!empty($user->email))<a href="mailto:{{ $user->email }}">{{ $user->email }}</a>@endif</td>
              <td class="text-center tb-col-icon-button">
                <form action="/user/{{ $user->id }}" method="post">
                  @csrf
                  <input type="hidden" name="_method" value="DELETE">
                  <button type="submit" class="btn btn-xs btn-outline-danger" aria-label="Left Align" onClick="del_check(event);"><span class="bi bi-trash3"></span></button>
                </form>
              </td>
            </tr>
            @endforeach
          </tbody>
        </table>
      </div>
    </div>
  </div>
  @include('common/pagination', ['tables' => $users])
</div>
@include('common/script-sort')
@include('common/script-del_check')
@endsection