<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
  <head>
    <title>{{ config('app.name', 'Laravel') }}</title>
    @include('common/header')
  </head>
  <body>
    <div class="container-fluid">
      <div class="row">
        <main role="main" class="col-md-9 mx-sm-auto col-lg-10 p-md-4 mt-3 mt-md-0">
          <div class="container-fluid px-0 mt-2 mb-4">
            <div class="row text-center mb-3">
              <div class="col">
                <h1 class="h2">緊急配車詳細情報</h1>
              </div>
            </div>
            <div class="row">
              <div class="col">
                <div class="card border-secondary mb-3 w-100">
                  <div class="card-header mb-2">@lang('db.reports') @lang('system.title.information')</div>
                  <div class="card-body">
                    <div class="container-fluid p-0 m-0">
                      <div class="row">
                        <div class="col-12 col-md-12">
                          <p>日付&nbsp;:&nbsp;<br class="d-sm-none" /><strong>{{ date('Y年n月j日', strtotime($report->start_at)) }}</strong></p>
                        </div>
                        <div class="col-12 col-md-6">
                          <p>@lang('db.report.user_id')&nbsp;:&nbsp;<br class="d-sm-none" /><strong>{{ $report->user->name }}</strong></p>
                        </div>
                        <div class="col-12 col-md-6">
                          <p>@lang('db.report.car_id')&nbsp;:&nbsp;<br class="d-sm-none" /><strong>{{ $report->car->number }}</strong></p>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="row mt-2">
              <div class="col">
                <div class="card border-secondary mb-3 w-100">
                  <div class="card-header mb-2">本日の既存配車予定</div>
                  <div class="card-body pt-1 pb-2">
                    @if ($report->waypoints->count() > 0)
                    <div class="table-responsive">
                      <table class="table table-hover text-nowrap">
                        <thead>
                          <tr>
                            <th class="text-start">@lang('db.report_waypoint.take_up')<span class="sort_button ms-2" data-sort="take_up"></span></th>
                            <th class="text-start">@lang('db.report_waypoint.take_down')<span class="sort_button ms-2" data-sort="take_down"></span></th>
                            <th class="text-start">@lang('db.report_waypoint.item_name')<span class="sort_button ms-2" data-sort="item_name"></span></th>
                            <th class="text-end">@lang('db.report_waypoint.quantity')<span class="sort_button ms-2" data-sort="quantity"></span></th>
                            <th class="text-start">@lang('db.report_waypoint.type_id')<span class="sort_button ms-2" data-sort="type_id"></span></th>
                            <th class="text-start">@lang('db.report_waypoint.address')<span class="sort_button ms-2" data-sort="address"></span></th>
                            <th class="text-start">@lang('db.report_waypoint.note')<span class="sort_button ms-2" data-sort="note"></span></th>
                          </tr>
                        </thead>
                        <tbody>
                          @foreach($report->waypoints as $report_waypoint)
                          @if(!empty($report_waypoint->emergency))
                          @continue
                          @endif
                          <tr>
                            <td class="text-start">{{ $report_waypoint->take_up }}</td>
                            <td class="text-start">{{ $report_waypoint->take_down }}</td>
                            <td class="text-start">{{ $report_waypoint->item_name }}</td>
                            <td class="text-end">@if(!empty($report_waypoint->quantity)){{ number_format($report_waypoint->quantity, 2) }}@if(!empty($report_waypoint->unit))&nbsp;{{ config('const.UNITS.'.$report_waypoint->unit) }}@endif @endif</td>
                            <td class="text-start">{{ $report_waypoint->type->name }}</td>
                            <td class="text-start">{{ $report_waypoint->address }}</td>
                            <td class="text-start"><span data-bs-toggle="tooltip" data-bs-placement="right" data-html="true" title="{{ $report_waypoint->note }}">{{ Str::limit($report_waypoint->note, 50) }}</span></td>
                          </tr>
                          @endforeach
                        </tbody>
                      </table>
                    </div>
                    @endif
                  </div>
                </div>
              </div>
            </div>
            @if ($report->waypoints->count() > 0)
            @foreach($report->waypoints as $report_waypoint)
            @if(empty($report_waypoint->emergency))
            @continue
            @endif
            <div class="row mt-2">
              <div class="col">
                <div class="card border-warning bg-warning bg-opacity-10 mb-3 w-100">
                  <div class="card-header mb-2 text-white bg-warning"><span class="bi bi-info-circle-fill me-1"></span><strong>緊急配車</strong></div>
                  <div class="card-body pt-1 pb-2">
                    <div class="table-responsive">
                      <table class="table table-hover text-nowrap">
                        <thead>
                          <tr>
                            <th class="text-start">@lang('db.report_waypoint.take_up')<span class="sort_button ms-2" data-sort="take_up"></span></th>
                            <th class="text-start">@lang('db.report_waypoint.take_down')<span class="sort_button ms-2" data-sort="take_down"></span></th>
                            <th class="text-start">@lang('db.report_waypoint.item_name')<span class="sort_button ms-2" data-sort="item_name"></span></th>
                            <th class="text-end">@lang('db.report_waypoint.quantity')<span class="sort_button ms-2" data-sort="quantity"></span></th>
                            <th class="text-start">@lang('db.report_waypoint.type_id')<span class="sort_button ms-2" data-sort="type_id"></span></th>
                            <th class="text-start">@lang('db.report_waypoint.address')<span class="sort_button ms-2" data-sort="address"></span></th>
                            <th class="text-start">@lang('db.report_waypoint.note')<span class="sort_button ms-2" data-sort="note"></span></th>
                          </tr>
                        </thead>
                        <tbody>
                          <tr>
                            <td class="text-start">{{ $report_waypoint->take_up }}</td>
                            <td class="text-start">{{ $report_waypoint->take_down }}</td>
                            <td class="text-start">{{ $report_waypoint->item_name }}</td>
                            <td class="text-end">@if(!empty($report_waypoint->quantity)){{ number_format($report_waypoint->quantity, 2) }}@if(!empty($report_waypoint->unit))&nbsp;{{ config('const.UNITS.'.$report_waypoint->unit) }}@endif @endif</td>
                            <td class="text-start">{{ $report_waypoint->type->name }}</td>
                            <td class="text-start">{{ $report_waypoint->address }}</td>
                            <td class="text-start"><span data-bs-toggle="tooltip" data-bs-placement="right" data-html="true" title="{{ $report_waypoint->note }}">{{ Str::limit($report_waypoint->note, 50) }}</span></td>
                          </tr>
                        </tbody>
                      </table>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="row mb-3">
              <div class="col">
                @if (!empty($report_waypoint->address))
                <iframe src="https://maps.google.com/maps?output=embed&q={{ urlencode($report_waypoint->address) }}&t=m&hl=ja&z=12" width="100%" height="450" frameborder="0" style="border:0;border-radius:0.25em;"></iframe>
                <p><a href="https://www.google.com/maps/dir/?api=1&destination={{ urlencode($report_waypoint->address) }}&travelmode=driving&dir_action=navigate" class="btn btn-info w-100" target="_blank"><span class="bi bi-geo-alt-fill me-2"></span>ルート案内開始</a></p>
                @endif
              </div>
            </div>
            @endforeach
            @endif
          </div>
        </div>
      </div>
    </main>
  </body>
  <script>
    let tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    let tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
      return new bootstrap.Tooltip(tooltipTriggerEl);
    });
  </script>
</html>
