<div class="container-fluid px-0">
  <div class="row text-center mb-3">
    <div class="col">
      <h1 class="h2">@lang('db.report_waypoint.emergency')</h1>
    </div>
  </div>
  @if($target == 'store' || $target == 'emergency')
  <form action="/emergency" method="post" onsubmit="return submitForm()">
  @endif
    @csrf
    <div class="row justify-content-center">
      <div class="col-12 col-md-12 col-lg-12">{{-- Set Input Form Size --}}
        @include('common/error-message')
        <div class="card border-warning mb-3 w-100">
          <div class="card-header mb-2 bg-warning bg-opacity-25">@lang('db.works') @lang('system.title.information')</div>
          <div class="card-body">
            <div class="container-fluid p-0 m-0">
              <div class="row">
                <div class="col-12 col-md-6">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report_waypoint.take_up')</label>
                    <input type="text" class="form-control @error('take_up') is-invalid @enderror" name="take_up" placeholder="" value="{{ old('take_up', $report_waypoint->take_up) }}">
                    @error('take_up')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                  </div>
                </div>
                <div class="col-12 col-md-6">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report_waypoint.take_down')</label>
                    <input type="text" class="form-control @error('take_down') is-invalid @enderror" name="take_down" placeholder="" value="{{ old('take_down', $report_waypoint->take_down) }}">
                    @error('take_down')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-12 col-md-12">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report_waypoint.address')</label>
                    <input type="text" id="address" class="form-control @error('address') is-invalid @enderror" name="address" placeholder="" value="{{ old('address', $report_waypoint->address) }}">
                    @error('address')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report_waypoint.item_name')</label>
                    <div class="container-fluid px-0">
                      <div class="row">
                        <div class="col-12 col-md-6">
                          <select id="item_select" class="form-select">
                            <option value=""></option>
                            @foreach ($items as $item)
                              <option value="{{ $item->name }}">{{ $item->name }}</option>
                            @endforeach
                          </select>
                          <div class="form-text">リストから選択または直接入力してください</div>
                        </div>
                        <div class="col-12 col-md-6">
                          <input type="text" id="item_name" class="form-control @error('item_name') is-invalid @enderror" name="item_name" placeholder="" value="{{ old('item_name', $report_waypoint->item_name) }}">
                          @error('item_name')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-12 col-md-6">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report_waypoint.quantity')</label>
                    <div class="container-fluid px-0">
                      <div class="row">
                        <div class="col-8 pe-1">
                          <input type="number" step="0.01" class="form-control @error('quantity') is-invalid @enderror" name="quantity" placeholder="" value="{{ old('quantity', $report_waypoint->quantity) }}">
                          @error('quantity')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                        </div>
                        <div class="col-4 ps-1">
                          <select class="form-select @error('unit') is-invalid @enderror" name="unit">
                            @foreach (config('const.UNITS'); as $key => $value)
                              <option value="{{ $key }}" @if(old('unit', $report_waypoint->unit)==$key) selected  @endif>{{ $value }}</option>
                            @endforeach
                          </select>
                          @error('unit')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="col-12 col-md-4">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report_waypoint.unit_price')</label>
                    <div class="input-group @error('unit_price') is-invalid @enderror">
                    <span class="input-group-text">@lang('system.unit.yen-mark')</span>
                      <input type="number" class="form-control @error('unit_price') is-invalid @enderror" name="unit_price" value="{{ old('unit_price', $report_waypoint->unit_price) }}">
                    </div>
                    @error('unit_price')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                  </div>
                </div>
                <div class="col-12 col-md-2">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report_waypoint.type_id')</label>
                    <select class="form-select @error('type_id') is-invalid @enderror" name="type_id">
                      @foreach ($types as $type)
                      <option value="{{ $type->id }}" @if(old('type_id', $report_waypoint->type_id)==$type->id) selected  @endif>{{ $type->name }}</option>
                      @endforeach
                    </select>
                    @error('type_id')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-12 col-md-6">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report_waypoint.billing_id')</label>
                    <select class="form-select @error('billing_id') is-invalid @enderror" name="billing_id">
                      <option value=""></option>
                      @foreach ($billings as $billing)
                      <option value="{{ $billing->id }}" @if(old('billing_id', $report_waypoint->billing_id)==$billing->id) selected  @endif>{{ $billing->name }}</option>
                      @endforeach
                    </select>
                    @error('billing_id')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                  </div>
                </div>
                <div class="col-12 col-md-6">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report_waypoint.billing_disposal_name')</label>
                    <input type="text" class="form-control @error('billing_disposal_name') is-invalid @enderror" name="billing_disposal_name" placeholder="" value="{{ old('billing_disposal_name', $report_waypoint->billing_disposal_name) }}">
                    @error('billing_disposal_name')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-12 col-md-6">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report_waypoint.highway_money')</label>
                    <div class="container-fluid px-0">
                      <div class="row">
                        <div class="col-8 pe-1">
                          <div class="input-group @error('highway_money') is-invalid @enderror">
                            <span class="input-group-text">@lang('system.unit.yen-mark')</span>
                            <input type="number" class="form-control @error('highway_money') is-invalid @enderror" name="highway_money" placeholder="" value="{{ old('highway_money', $report_waypoint->highway_money) }}">
                          </div>
                          @error('highway_money')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                          <span class="invalid-feedback" role="alert"><strong>unyaaaaa</strong></span>
                        </div>
                        <div class="col-4 ps-1">
                          <select class="form-select @error('highway_payment') is-invalid @enderror" name="highway_payment">
                            <option value=""></option>
                            @foreach (config('const.PAYMENTS'); as $key => $value)
                              <option value="{{ $key }}" @if(old('highway_payment', $report_waypoint->highway_payment)==$key) selected  @endif>{{ $value }}</option>
                            @endforeach
                          </select>
                          @error('highway_payment')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="col-12 col-md-6">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report_waypoint.emergency')</label>
                    <input type="hidden" name="emergency" value="1">
                    <div class="form-text">この経路を緊急配車に指定します。一覧に<span class="bi bi-info-circle-fill mx-1 text-warning"></span>アイコンが付き、ダッシュボードで強調表示されます。</div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="card border-secondary mb-3 w-100">
          <div class="card-header mb-2">運転者自動割り当て</div>
          <div class="card-body">
            <div class="container-fluid p-0 m-0">
              <div class="row">
                <div class="col-12 col-md-6">
                  <label class="form-label mb-2">自動割り当て</label>
                  <a class="btn btn-outline-warning w-100 fw-bold" onclick="ajaxGetReportId()"><span class="bi bi-arrow-clockwise me-1"></span>配車情報から自動割り当てを行う</a>
                </div>
                <div class="col-12 col-md-6">
                  <label class="form-label mb-2">@lang('db.report.user_id')</label>
                  <select id="select_report" class="form-control @error('report_id') is-invalid @enderror" name="report_id">
                    <option value=""></option>
                    @foreach ($today_reports as $today_report)
                    <option value="{{ $today_report->id }}" @if(old('report_id')==$today_report->id) selected  @endif>{{ $today_report->user->name }}【{{ $today_report->car->number }}】</option>
                    @endforeach
                  </select>
                  @error('report_id')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="row justify-content-center mb-4">
      <div class="col-12 col-md-5 col-lg-4 mt-2 mb-2">{{-- Not Change --}}
        <button type="submit" id="submit-button" class="btn btn-warning w-100"><span class="bi bi-check-circle me-2"></span>緊急配車を実行する</button>
      </div>
      <div class="col-12 col-md-3 col-lg-2 mt-2 mb-2">
        @if (session()->has('checkpoint-second'))
        <a href="{{ session()->get('checkpoint-second') }}" class="btn btn-outline-primary w-100"><span class="bi bi-caret-left me-1"></span>@lang('system.command.back')</a>
        @else
        <a href="./" class="btn btn-outline-primary w-100"><span class="bi bi-caret-left me-1"></span>@lang('system.command.back')</a>
        @endif
      </div>
    </div>
  </form>
</div>
@include('common/script-form')
<script>
    window.addEventListener('load', function() {
        document.getElementById('item_select').addEventListener('change', function() {
          let item_name = document.getElementById('item_name');
          item_name.value = this.value;
          return;
        }, false);
    }, false);
    function ajaxGetReportId() {

      let list = document.getElementById('select_report')
      let options = list.options
      let xhr = new XMLHttpRequest();
      let address = document.getElementById("address").value;
      let url = "/emergency/get/report";
      if (address != '') {
        url = "/emergency/get/report?address="+address;
      }

      xhr.onerror = function () {
        console.log("error");
      };

      Array.from(options).forEach(function(option) {
        option.removeAttribute("selected");
      });

      xhr.onreadystatechange = function () {
        if (this.readyState === 4 && this.status === 200) {
          let response = this.response;
          if (typeof response === "string") {
            response = JSON.parse(response);
          }
          if (response.status == 'success') {
            list.querySelector("option[value='"+response.data+"']").setAttribute("selected", "selected");
          } else {
            alert('自動割り当ての対象となる運転者が見つかりませんでした。\n入力した住所または本日のスケジュールをご確認ください。');
          }
          // console.log(response);
          // alert("Success: " + r.responseText);
        }
      };

      xhr.open("GET", url, true);
      xhr.responseType = "json";
      xhr.send();

    }
</script>