@extends('common/main/layout')
@section('content')
<div class="container-fluid px-0">
  <div class="row mb-3">
    <div class="col">
      <h1 class="h2">{{date('Y年n月j日', strtotime('today'))}} @lang('db.report_waypoint.emergency')</h1>
    </div>
  </div>
  @include('common/error-message')
  <div class="row">
    <div class="col-12 col-md">
      <a href="./emergency/create" class="btn btn-warning m-2 fw-bold"><span class="bi bi-info-circle-fill me-2"></span>@lang('db.report_waypoint.emergency')</a>
    </div>
    <div class="col-12 col-md text-md-end">
      @if (session()->has('checkpoint'))
      <a href="{{ session()->get('checkpoint') }}" class="btn btn-outline-primary ms-4"><span class="bi bi-caret-left me-1"></span>@lang('system.command.back')</a>
      @else
      <a href="../" class="btn btn-outline-primary ms-4"><span class="bi bi-caret-left me-1"></span>@lang('system.command.back')</a>
      @endif
    </div>
  </div>
  <div class="row">
    <div class="col">
      <div class="table-responsive">
        <table class="table table-hover text-nowrap">
          <thead>
            <tr>
              <th class="text-start">@lang('db.report.user_id')</th>
              <th class="text-start">@lang('db.report.car_id')</th>
              <th class="text-start">@lang('db.report_waypoint.take_up')<span class="sort_button ms-2" data-sort="take_up"></span></th>
              <th class="text-start">@lang('db.report_waypoint.take_down')<span class="sort_button ms-2" data-sort="take_down"></span></th>
              <th class="text-start">@lang('db.report_waypoint.address')<span class="sort_button ms-2" data-sort="address"></span></th>
              <th class="text-start">@lang('db.report_waypoint.item_name')<span class="sort_button ms-2" data-sort="item_name"></span></th>
              <th class="text-end">@lang('db.report_waypoint.quantity')<span class="sort_button ms-2" data-sort="quantity"></span></th>
              <th class="text-end">@lang('db.report_waypoint.unit_price')<span class="sort_button ms-2" data-sort="unit_price"></span></th>
              <th class="text-start">@lang('db.report_waypoint.type_id')<span class="sort_button ms-2" data-sort="type_id"></span></th>
              <th class="text-start">@lang('db.report_waypoint.billing_id')<span class="sort_button ms-2" data-sort="billing_id"></span></th>
              <th class="text-start">@lang('db.report_waypoint.billing_disposal_name')<span class="sort_button ms-2" data-sort="billing_disposal_name"></span></th>
              <th class="text-end">@lang('db.report_waypoint.highway_money')<span class="sort_button ms-2" data-sort="highway_money"></span></th>
            </tr>
          </thead>
          <tbody>
            @foreach($report_waypoints as $report_waypoint)
            <tr>
              <td class="text-start">{{ $report_waypoint->report->user->name }}</td>
              <td class="text-start">{{ $report_waypoint->report->car->number }}</td>
              <td class="text-start">@if(!empty($report_waypoint->emergency))<span class="bi bi-info-circle-fill me-1 text-warning"></span>@endif{{ $report_waypoint->take_up }}</td>
              <td class="text-start">{{ $report_waypoint->take_down }}</td>
              <td class="text-start">{{ $report_waypoint->address }}</td>
              <td class="text-start">{{ $report_waypoint->item_name }}</td>
              <td class="text-end">{{ number_format($report_waypoint->quantity, 2) }}@if(!empty($report_waypoint->unit))&nbsp;{{ config('const.UNITS.'.$report_waypoint->unit) }}@endif</td>
              <td class="text-end">@lang('system.unit.yen-mark'){{ number_format($report_waypoint->unit_price) }}</td>
              <td class="text-start">{{ $report_waypoint->type->name }}</td>
              <td class="text-start">@if(!empty($report_waypoint->billing_id)){{ $report_waypoint->billing->name }}@endif</td>
              <td class="text-start">{{ $report_waypoint->billing_disposal_name }}</td>
              <td class="text-end">@lang('system.unit.yen-mark'){{ number_format($report_waypoint->highway_money) }}@if($report_waypoint->highway_money > 0 && !empty($report_waypoint->highway_payment))&nbsp;&#40;{{ config('const.PAYMENTS.'.$report_waypoint->highway_payment) }}&#41;@endif</td>
            </tr>
            @endforeach
          </tbody>
        </table>
      </div>
    </div>
  </div>
  @include('common/pagination', ['tables' => $report_waypoints])
</div>
@include('common/script-del_check')
@endsection