<script src="https://ajaxzip3.github.io/ajaxzip3.js" charset="UTF-8"></script>
<div class="container-fluid px-0">
  <div class="row text-center mb-3">
    <div class="col">
      @if($target == 'store')
      <h1 class="h2">@lang('db.billings') @lang('system.title.create')</h1>
      @elseif($target == 'update')
      <h1 class="h2">@lang('db.billings') @lang('system.title.edit')</h1>
      @endif
    </div>
  </div>
  @if($target == 'store')
  <form action="/billing" method="post" onsubmit="return submitForm()">
  @elseif($target == 'update')
  <form action="/billing/{{ $billing->id }}" name="" method="post" onsubmit="return submitForm()">
    <input type="hidden" name="_method" value="PUT">
  @endif
    @csrf
    <div class="row justify-content-center">
      <div class="col-12 col-md-8 col-lg-6">{{-- Set Input Form Size --}}
        @include('common/error-message')
        <div class="card border-secondary mb-3 w-100">
          <div class="card-header mb-2">@lang('db.billings') @lang('system.title.information')</div>
          <div class="card-body">
            <div class="form-group mb-4">
              <label class="form-label mb-2">@lang('db.billing.name')</label>
              <input type="text" class="form-control @error('name') is-invalid @enderror" name="name" placeholder="" value="{{ old('name', $billing->name) }}">
              @error('name')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
            </div>
            <div class="form-group mb-4">
              <label class="form-label mb-2">@lang('db.billing.zip_code')</label>
              <input type="text" class="form-control @error('zip_code') is-invalid @enderror w-50" name="zip_code" maxlength="8" value="{{ old('zip_code', $billing->zip_code) }}" onKeyUp="AjaxZip3.zip2addr(this,'','address_1','address_1');">
              @error('zip_code')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
            </div>
            <div class="form-group mb-4">
              <label class="form-label mb-2">@lang('db.billing.address_1')</label>
              <input type="text" class="form-control @error('address_1') is-invalid @enderror" name="address_1" value="{{ old('address_1', $billing->address_1) }}">
              @error('address_1')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
            </div>
            <div class="form-group mb-4">
              <label class="form-label mb-2">@lang('db.billing.address_2')</label>
              <input type="text" class="form-control @error('address_2') is-invalid @enderror" name="address_2" value="{{ old('address_2', $billing->address_2) }}">
              @error('address_2')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
            </div>
            <div class="form-group mb-4">
              <label class="form-label mb-2">@lang('db.billing.phone_number')</label>
              <input type="tel" class="form-control @error('phone_number') is-invalid @enderror" name="phone_number" value="{{ old('phone_number', $billing->phone_number) }}">
              @error('phone_number')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
            </div>
            <div class="form-group mb-4">
              <label class="form-label mb-2">@lang('db.billing.person_in_charge')</label>
              <input type="text" class="form-control @error('person_in_charge') is-invalid @enderror" name="person_in_charge" value="{{ old('person_in_charge', $billing->person_in_charge) }}">
              @error('person_in_charge')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
            </div>
            <div class="form-group mb-4">
              <label class="form-label mb-2">@lang('db.billing.note')</label>
              <textarea class="form-control @error('note') is-invalid @enderror" id="exampleTextarea" rows="3" name="note">{{ old('note', $billing->note) }}</textarea>
              @error('note')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="row justify-content-center mb-4">
      <div class="col-12 col-md-5 col-lg-4 mt-2 mb-2">{{-- Not Change --}}
        <button type="submit" id="submit-button" class="btn btn-primary w-100"><span class="bi bi-check-circle me-2"></span>@lang('system.command.register')</button>
      </div>
      <div class="col-12 col-md-3 col-lg-2 mt-2 mb-2">
        @if (session()->has('checkpoint'))
        <a href="{{ session()->get('checkpoint') }}" class="btn btn-outline-primary w-100"><span class="bi bi-caret-left me-1"></span>@lang('system.command.back')</a>
        @else
        <a href="./" class="btn btn-outline-primary w-100"><span class="bi bi-caret-left me-1"></span>@lang('system.command.back')</a>
        @endif
      </div>
    </div>
  </form>
</div>
@include('common/script-form')
