@extends('common/main/layout')
@section('content')
<div class="container-fluid px-0">
  <div class="row mb-3">
    <div class="col">
      <h1 class="h2">@lang('db.billings') @lang('system.title.index')</h1>
    </div>
  </div>
  @include('common/error-message')
  <div class="row">
    <div class="col">
      <a href="/billing/create" class="btn btn-primary m-2"><span class="bi bi-plus-square me-2"></span>@lang('system.command.create')</a>
    </div>
  </div>
  <div class="row">
    <div class="col">
      <div class="table-responsive">
        <table class="table table-hover text-nowrap">
          <thead>
            <tr>
              <th class="text-center tb-col-icon-button">@lang('system.command.edit')</th>
              <th class="text-center tb-col-id">@lang('db.billing.id')<span class="sort_button ms-2" data-sort="id"></span</th>
              <th class="text-start">@lang('db.billing.name')<span class="sort_button ms-2" data-sort="name"></span></th>
              <th class="text-start">@lang('db.billing.address')<span class="sort_button ms-2" data-sort="address_1"></span></th>
              <th class="text-center tb-col-icon-button">@lang('system.command.delete')</th>
            </tr>
          </thead>
          <tbody>
            @foreach($billings as $billing)
            <tr>
              <td class="text-center tb-col-icon-button">
                <a href="/billing/{{ $billing->id }}/edit" class="btn btn-xs btn-success"><span class="bi bi-pencil-fill"></span></a>
              </td>
              <td class="text-center tb-col-id">{{ $billing->id }}</td>
              <td class="text-start">{{ $billing->name }}</td>
              <td class="text-start">{{ Str::limit($billing->zip_code.' '.$billing->address_1.' '.$billing->address_2, 50) }}</td>
              <td class="text-center tb-col-icon-button">
                <form action="/billing/{{ $billing->id }}" method="post">
                  @csrf
                  <input type="hidden" name="_method" value="DELETE">
                  <button type="submit" class="btn btn-xs btn-outline-danger" aria-label="Left Align" onClick="del_check(event);"><span class="bi bi-trash3"></span></button>
                </form>
              </td>
            </tr>
            @endforeach
          </tbody>
        </table>
      </div>
    </div>
  </div>
  @include('common/pagination', ['tables' => $billings])
</div>
@include('common/script-sort')
@include('common/script-del_check')
@endsection