<div class="container-fluid px-0">
  <div class="row text-center mb-3">
    <div class="col">
      @if($target == 'store')
      <h1 class="h2">@lang('db.cars') @lang('system.title.create')</h1>
      @elseif($target == 'update')
      <h1 class="h2">@lang('db.cars') @lang('system.title.edit')</h1>
      @endif
    </div>
  </div>
  @if($target == 'store')
  <form action="/car" method="post" onsubmit="return submitForm()">
  @elseif($target == 'update')
  <form action="/car/{{ $car->id }}" name="" method="post" onsubmit="return submitForm()">
    <input type="hidden" name="_method" value="PUT">
  @endif
    @csrf
    <div class="row justify-content-center">
      <div class="col-12 col-md-8 col-lg-6">{{-- Set Input Form Size --}}
        @include('common/error-message')
        <div class="card border-secondary mb-3 w-100">
          <div class="card-header mb-2">@lang('db.cars') @lang('system.title.information')</div>
          <div class="card-body">
            <div class="form-group mb-4">
              <label class="form-label mb-2">@lang('db.car.name')</label>
              <input type="text" class="form-control @error('name') is-invalid @enderror" name="name" value="{{ old('name', $car->name) }}">
              @error('name')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
            </div>
            <div class="form-group mb-4">
              <label class="form-label mb-2">@lang('db.car.format')</label>
              <input type="text" class="form-control @error('format') is-invalid @enderror" name="format" value="{{ old('format', $car->format) }}">
              @error('format')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
            </div>
            <div class="form-group mb-4">
              <label class="form-label mb-2">@lang('db.car.size')</label>
              <input type="text" class="form-control @error('size') is-invalid @enderror" name="size" value="{{ old('size', $car->size) }}">
              @error('size')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
            </div>
            <div class="form-group mb-4">
              <label class="form-label mb-2">@lang('db.car.number')</label>
              <input type="text" class="form-control @error('number') is-invalid @enderror" name="number" placeholder="" value="{{ old('number', $car->number) }}">
              @error('number')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
            </div>
            <div class="form-group mb-4">
              <label class="form-label mb-2">@lang('db.car.capacity')</label>
              <div class="input-group @error('capacity') is-invalid @enderror">
                <input type="number" class="form-control @error('capacity') is-invalid @enderror" name="capacity" value="{{ old('capacity', $car->capacity) }}">
                <span class="input-group-text">kg</span>
              </div>
              @error('capacity')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
            </div>
            <div class="form-group mb-4">
              <label class="form-label mb-2">@lang('db.car.maker')</label>
              <input type="text" class="form-control @error('maker') is-invalid @enderror" name="maker" value="{{ old('maker', $car->maker) }}">
              @error('maker')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
            </div>
            <div class="form-group mb-4">
              <label class="form-label mb-2">@lang('db.car.inspection_at')</label>
              @php
                $old_inspection_at = '';
                if ($target == 'update' && !empty($car->inspection_at)) {
                  $old_inspection_at = date('Y-m-d', strtotime($car->inspection_at));
                }
              @endphp
              <input type="date" class="form-control @error('inspection_at') is-invalid @enderror" name="inspection_at" placeholder="" value="{{ old('inspection_at', $old_inspection_at) }}">
              @error('inspection_at')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
            </div>
            <div class="form-group mb-4">
              <label class="form-label mb-2">@lang('db.car.inspection_next_at')</label>
              @php
                $old_inspection_next_at = '';
                if ($target == 'update' && !empty($car->inspection_next_at)) {
                  $old_inspection_next_at = date('Y-m', strtotime($car->inspection_next_at));
                }
              @endphp
              <input type="month" class="form-control @error('inspection_next_at') is-invalid @enderror" name="inspection_next_at" placeholder="" value="{{ old('inspection_next_at', $old_inspection_next_at) }}">
              @error('inspection_next_at')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
            </div>

            <div class="form-group mb-4">
              <label class="form-label mb-2">@lang('db.car.use')</label>
              <div class="form-check @error('use') is-invalid @enderror">
                <label class="form-check-label">
                  <input type="radio" class="form-check-input @error('use') is-invalid @enderror" name="use" value="1" @if(old('use', $car->use)=='1') checked  @endif>
                  @lang('db.car.use-1')
                </label>
              </div>
              <div class="form-check @error('use') is-invalid @enderror">
                <label class="form-check-label">
                  <input type="radio" class="form-check-input @error('use') is-invalid @enderror" name="use" value="0" @if(old('use', $car->use)=='0') checked  @endif>
                  @lang('db.car.use-0')
                </label>
              </div>
              @error('use')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
            </div>
            <div class="form-group mb-4">
              <label class="form-label mb-2">@lang('db.car.note')</label>
              <textarea class="form-control @error('note') is-invalid @enderror" id="exampleTextarea" rows="3" name="note">{{ old('note', $car->note) }}</textarea>
              @error('note')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="row justify-content-center mb-4">
      <div class="col-12 col-md-5 col-lg-4 mt-2 mb-2">{{-- Not Change --}}
        <button type="submit" id="submit-button" class="btn btn-primary w-100"><span class="bi bi-check-circle me-2"></span>@lang('system.command.register')</button>
      </div>
      <div class="col-12 col-md-3 col-lg-2 mt-2 mb-2">
        @if (session()->has('checkpoint'))
        <a href="{{ session()->get('checkpoint') }}" class="btn btn-outline-primary w-100"><span class="bi bi-caret-left me-1"></span>@lang('system.command.back')</a>
        @else
        <a href="./" class="btn btn-outline-primary w-100"><span class="bi bi-caret-left me-1"></span>@lang('system.command.back')</a>
        @endif
      </div>
    </div>
  </form>
</div>
@include('common/script-form')
