@extends('common/main/layout')
@section('content')
<div class="container-fluid px-0">
  <div class="row mb-3">
    <div class="col">
      <h1 class="h2">@lang('db.cars') @lang('system.title.index')</h1>
    </div>
  </div>
  @include('common/error-message')
  <div class="row">
    <div class="col">
      <a href="/car/create" class="btn btn-primary m-2"><span class="bi bi-plus-square me-2"></span>@lang('system.command.create')</a>
    </div>
  </div>
  <div class="row">
    <div class="col">
      <div class="table-responsive">
        <table class="table table-hover text-nowrap">
          <thead>
            <tr>
              <th class="text-center tb-col-icon-button">@lang('system.command.edit')</th>
              <th class="text-center tb-col-id">@lang('db.car.id')<span class="sort_button ms-2" data-sort="id"></span</th>
              <th class="text-start">@lang('db.car.name')<span class="sort_button ms-2" data-sort="name"></span></th>
              <th class="text-start">@lang('db.car.number')<span class="sort_button ms-2" data-sort="number"></span></th>
              <th class="text-start">@lang('db.car.maker')<span class="sort_button ms-2" data-sort="maker"></span></th>
              <th class="text-start">@lang('db.car.use')<span class="sort_button ms-2" data-sort="use"></span></th>
              <th class="text-start">@lang('db.car.inspection_at')<span class="sort_button ms-2" data-sort="inspection_at"></span></th>
              <th class="text-start">@lang('db.car.inspection_next_at')<span class="sort_button ms-2" data-sort="inspection_next_at"></span></th>
              <th class="text-center tb-col-icon-button">@lang('system.command.delete')</th>
            </tr>
          </thead>
          <tbody>
            @foreach($cars as $car)
            <tr>
              <td class="text-center tb-col-icon-button">
                <a href="/car/{{ $car->id }}/edit" class="btn btn-xs btn-success"><span class="bi bi-pencil-fill"></span></a>
              </td>
              <td class="text-center tb-col-id">{{ $car->id }}</td>
              <td class="text-start">{{ $car->name }}</td>
              <td class="text-start">{{ $car->number }}</td>
              <td class="text-start">{{ $car->maker }}</td>
              <td class="text-start">@lang('db.car.use-'.$car->use)</td>
              <td class="text-start">@if(!empty($car->inspection_at)){{ date('Y年n月j日', strtotime($car->inspection_at)) }}@endif</td>
              <td class="text-start">@if(!empty($car->inspection_next_at)){{ date('Y年n月', strtotime($car->inspection_next_at)) }}@endif</td>
              <td class="text-center tb-col-icon-button">
                <form action="/car/{{ $car->id }}" method="post">
                  @csrf
                  <input type="hidden" name="_method" value="DELETE">
                  <button type="submit" class="btn btn-xs btn-outline-danger" aria-label="Left Align" onClick="del_check(event);"><span class="bi bi-trash3"></span></button>
                </form>
              </td>
            </tr>
            @endforeach
          </tbody>
        </table>
      </div>
    </div>
  </div>
  @include('common/pagination', ['tables' => $cars])
</div>
@include('common/script-sort')
@include('common/script-del_check')
@endsection