<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
  <head>
    <title>{{ config('app.name', 'Laravel') }}</title>
    @include('common/header')
    <style>
      body {
        background-image: url("{{ asset('img/bg-image.jpg') }}");
        background-attachment: fixed;
        background-repeat: no-repeat;
        background-size: cover;
        background-position: center center;
        background-color:rgba(255,255,255,0.5);
        background-blend-mode:lighten;
        height: 100vh;
        width: 100%;
      }
      
      .wrapper {    
        max-width: 420px;
      }

      .form-signin {
        border: 0.2px solid rgba(0,0,0,0.1);  
        border-radius: 10px;
        box-shadow: 0 0 2rem rgba(0,0,0,.3)!important;
        padding: 38px 38px 38px;
        margin: 0 auto;
        background-color: rgba(255,255,255,0.9);
      }

      .form-signin-heading {
        text-align:center;
        margin-bottom: 1.5rem;
        font-family: 'Roboto Condensed', sans-serif;
      }

      .colorgraph {
        height: 7px;
        margin-top: 1.75rem;
        margin-bottom: 1.75rem;
        border-top: 0;
        background: #bcd97a;
        border-radius: 5px;
        opacity: .75;
        background-image: -webkit-linear-gradient(left, #bcd97a, #bcd97a 12.5%, #eaf974 12.5%, #eaf974 25%, #fecf71 25%, #fecf71 37.5%, #f0776c 37.5%, #f0776c 50%, #e693be 50%, #e693be 62.5%, #c49cde 62.5%, #c49cde 75%, #669ae1 75%, #669ae1 87.5%, #62c2e4 87.5%, #62c2e4);
        background-image: -moz-linear-gradient(left, #bcd97a, #bcd97a 12.5%, #eaf974 12.5%, #eaf974 25%, #fecf71 25%, #fecf71 37.5%, #f0776c 37.5%, #f0776c 50%, #e693be 50%, #e693be 62.5%, #c49cde 62.5%, #c49cde 75%, #669ae1 75%, #669ae1 87.5%, #62c2e4 87.5%, #62c2e4);
        background-image: -o-linear-gradient(left, #bcd97a, #bcd97a 12.5%, #eaf974 12.5%, #eaf974 25%, #fecf71 25%, #fecf71 37.5%, #f0776c 37.5%, #f0776c 50%, #e693be 50%, #e693be 62.5%, #c49cde 62.5%, #c49cde 75%, #669ae1 75%, #669ae1 87.5%, #62c2e4 87.5%, #62c2e4);
        background-image: linear-gradient(to right, #bcd97a, #bcd97a 12.5%, #eaf974 12.5%, #eaf974 25%, #fecf71 25%, #fecf71 37.5%, #f0776c 37.5%, #f0776c 50%, #e693be 50%, #e693be 62.5%, #c49cde 62.5%, #c49cde 75%, #669ae1 75%, #669ae1 87.5%, #62c2e4 87.5%, #62c2e4);
      }

      .logo {
        width: 75px;
        display: block;
        margin: 0 auto;
      }
    </style>
  </head>
  <body>
    <div class="position-absolute h-100 w-100 m-0 d-flex align-items-center justify-content-center">
      <div class="wrapper">
        <form action="{{ route('authenticate') }}" method="post" class="form-signin">
          @csrf
          <h2 class="form-signin-heading text-primary fw-bold">{{ config('app.name', 'Laravel') }}</h2>
          <img src="{{ asset('img/icon/256x256.png') }}" class="logo" />
          
          <hr class="colorgraph" size="7">
          <input type="text" class="form-control @error('account') is-invalid @enderror" name="account" placeholder="@lang('system.login.account')" value="{{ old('account') }}" />
          @error('account')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
          <input type="password" class="form-control mt-2 @error('password') is-invalid @enderror" name="password" placeholder="@lang('system.login.password')" />
          @error('password')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
        
          <button type="submit" class="btn btn-lg btn-primary btn-block w-100 mt-4" name="submit">@lang('system.login.submit')</button>
        </form>
      </div>
    </div>
  </body>
</html>