{{-- 
  メインレイアウト
    $search_target   検索バーのプレースホルダーに表示される値。コントローラーから指定する。省略した際は検索バーが非活性化される。

  標準継承先ビュー
    index:
      一覧を表示する。
    create:
      フォームをstoreモードで呼び出す。
    edit:
      フォームをupdateモードで呼び出す。
    form:
      フォームの大きさを変える場合は"Set Input Form Size"のcolを変更する。デフォルトはcol-12 col-md-8 col-lg-6。
      ボタンの方のcolは変更しない。これは、全フォーム画面のボタン位置を固定することで操作性を安定させるため。あと、フォーム幅100%でボタンを出すと大きすぎる。
--}}
<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
  <head>
    <title>{{ config('app.name', 'Laravel') }}</title>
    @include('common/header')
    @if (!empty($search_target))
    <style>
      @media (max-width: 767.98px) {
        .sidebar {
          top: 3.25rem;
        }
        .sidebar-sticky {
          height: calc(100vh - 200px);
        }
      }
    </style>
    @else
    <style>
      @media (max-width: 767.98px) {
        .sidebar-sticky {
          height: calc(100vh - 150px);
        }
      }
    </style>
    @endif
    @if (!empty($params))
    <script>
      inParams = @json($params);
    </script>
    @endif
  </head>
  <body>
    <nav class="navbar navbar-expand-md sticky-top navbar-dark bg-primary">
      <div class="container-fluid">
        <a class="app-name navbar-brand ms-0 px-2" href="{{ route('home') }}"><img src="{{ asset('img/icon/32x32.png') }}" class="navbar-logo me-2" />{{ config('app.name', 'Laravel') }}</a>
        <button class="navbar-toggler position-absolute top-0 end-0 mt-3 me-3 d-md-none collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#sidebarMenu" aria-controls="SidebarMenu" aria-expanded="false" aria-label="Toggle navigation">
          <span class="navbar-toggler-icon"></span>
        </button>
        @if (!empty($search_target))
        <input id="search_box" class="form-control form-control-dark w-100 mt-3 mt-md-0" type="search" placeholder="@if(!empty($search_target)){{ $search_target }}@endif" aria-label="search" name="search" value="@if(!empty($params['search'])){{ $params['search'] }}@endif" autocomplete="off">
        @else
        <input id="search_box" type="hidden">
        @endif
        <div class="d-none d-md-block">
          <ul class="navbar-nav ms-0 ps-2 mt-2 mt-md-0 text-right">
            <li class="nav-item text-nowrap">
              <a class="nav-link" href="{{ route('logout') }}" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                <span class="bi bi-door-open-fill"></span><span class="ms-2">@lang('system.command.logout')</span>
              </a>
              <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                @csrf
              </form>
            </li>
          </ul>
        </div>
      </div>
    </nav>
    <div class="container-fluid">
      <div class="row">
        <nav id="sidebarMenu" class="col-md-3 col-lg-2 d-md-block bg-light sidebar collapse mt-3 mt-md-0">
          <div class="sidebar-sticky pt-3">
            <h6 class="d-flex justify-content-between align-items-center px-3 mt-2 mb-4">
              <span class="text-primary fw-bold">{{ Auth::user()->name }}<small class="ms-1">@lang('system.honorific.sama')</small></span>
            </h6>
            @include('common/main/menu')
          </div>
        </nav>
        <main role="main" class="col-md-9 ms-sm-auto col-lg-10 p-md-4 mt-3 mt-md-0">
          @yield('content')
        </main>
      </div>
    </div>
    <script>
        window.addEventListener('load', function() {
            document.getElementById('search_box').addEventListener('search', function() {
              let requests = {
                search: this.value
              }
              let url = getRequestUrl(requests);
              if (!url) return;

              window.location.href = url;
              return;
            }, false);
        }, false);
    </script>
  </body>
</html>