@extends('common/main/layout')
@section('content')
<div class="container-fluid px-0">
  <div class="row mb-3">
    <div class="col">
      <h1 class="h2">@lang('db.csv_billing')@lang('system.title.export')</h1>
    </div>
  </div>
  @include('common/error-message')
  <form action="{{ route('csv.billing.download') }}" method="get">
    @csrf
    <div class="row">
      <div class="d-none d-md-block col-12 col-md">
      </div>
      <div class="col col-md p-2">
        <select id="search_billing_id" class="form-select" name="billing_id">
          <option value="all">すべて出力</option>
          @foreach ($billings as $billing)
            <option value="{{ $billing->id }}" @if($params['billing_id'] == $billing->id) selected  @endif>{{ $billing->name }}</option>
          @endforeach
        </select>
      </div>
      <div class="col-12 col-md p-2">
        <div class="input-group ">
          <span class="input-group-text">開始日</span>
          <input type="date" class="form-control" name="from_at" placeholder="" value="{{ old('from_at', date('Y-m-d', strtotime($params['from_at']))) }}">
        </div>
      </div>
      <div class="col-12 col-md p-2">
        <div class="input-group ">
          <span class="input-group-text">終了日</span>
          <input type="date" class="form-control" name="to_at" placeholder="" value="{{ old('to_at', date('Y-m-d', strtotime($params['to_at']))) }}">
        </div>
      </div>
    </div>
    <div class="row justify-content-center mt-4 mb-4">
      <div class="col-12 col-md-5 col-lg-4 mt-2 mb-2">
        <button type="submit" id="submit-button" class="btn btn-primary w-100"><span class="bi bi-download me-2"></span>@lang('system.command.export')</button>
      </div>
    </div>
  </form>
</div>
@endsection