@extends('common/main/layout')
@section('content')
<div class="container-fluid px-0">
  <div class="row mb-3">
    <div class="col">
      <h1 class="h2">@lang('db.examples') @lang('system.title.index')</h1>
    </div>
  </div>
  @include('common/error-message')
  <div class="row">
    <div class="col">
      <a href="/example/create" class="btn btn-primary m-2"><span class="bi bi-plus-square me-2"></span>@lang('system.command.create')</a>
    </div>
  </div>
  <div class="row">
    <div class="col">
      <div class="table-responsive">
        <table class="table table-hover text-nowrap">
          <thead>
            <tr>
              <th class="text-center tb-col-icon-button">@lang('system.command.edit')</th>
              <th class="text-center tb-col-id">@lang('db.example.id')<span class="sort_button ms-2" data-sort="id"></span></th>
              <th class="text-start">@lang('db.example.name')<span class="sort_button ms-2" data-sort="name"></span></th>
              <th class="text-end">@lang('db.example.price')<span class="sort_button ms-2" data-sort="price"></span></th>
              <th class="text-start">@lang('db.example.author')<span class="sort_button ms-2" data-sort="author"></span></th>
              <th class="text-center tb-col-icon-button">@lang('system.command.delete')</th>
            </tr>
          </thead>
          <tbody>
            @foreach($examples as $example)
            <tr>
              <td class="text-center tb-col-icon-button">
                <a href="/example/{{ $example->id }}/edit" class="btn btn-xs btn-success"><span class="bi bi-pencil-fill"></span></a>
              </td>
              <td class="text-center tb-col-id">{{ sprintf('%04d', $example->id) }}</td>
              <td class="text-start">{{ $example->name }}</td>
              <td class="text-end">{{ number_format($example->price) }}<span class="ms-1">@lang('system.unit.yen')</span></td>
              <td class="text-start">{{ $example->author }}</td>
              <td class="text-center tb-col-icon-button">
                <form action="/example/{{ $example->id }}" method="post">
                  @csrf
                  <input type="hidden" name="_method" value="DELETE">
                  <button type="submit" class="btn btn-xs btn-outline-danger" aria-label="Left Align" onClick="del_check(event);"><span class="bi bi-trash3"></span></button>
                </form>
              </td>
            </tr>
            @endforeach
          </tbody>
        </table>
      </div>
    </div>
  </div>
  @include('common/pagination', ['tables' => $examples])
</div>
@include('common/script-sort')
@include('common/script-del_check')
@endsection