@extends('common/main/layout')
@section('content')
<div class="container-fluid px-0">
  <div class="row mb-3">
    <div class="col">
      <h1 class="h2">@lang('system.title.home')</h1>
    </div>
  </div>
{{-- 日報作成案内 --}}
@if ($reports->count() === 0)
  <div class="row">
    <div class="col">
      <div class="alert alert-dismissible alert-info">
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        {{ Auth::user()->name }}さんの今日（始業時間{{ $work_start_time }}）の@lang('db.reports')はまだ作成されていません。
      </div>
    </div>
  </div>
@endif
{{-- 日報カード生成 --}}
@if ($reports->count() > 0)
  <div class="row">
    @foreach($reports->get() as $report)
    <div class="col-12 col-md-6">
      <div class="card border-primary mb-3">
        <div class="card-header">{{ date('Y年n月j日', strtotime($report->start_at)) }}の@lang('db.reports')<a href="/report/{{ $report->id }}/edit" class="btn btn-xs btn-success fw-bold ms-2"><span class="bi bi-pencil-fill"></span></a></div>
        <div class="card-body">
          <div class="container-fluid p-0 m-0">
            <div class="row">
              <div class="col-12 col-md-6">
                <p><span class="bi bi-truck me-2"></span>@lang('db.report.car_id')&nbsp;:&nbsp;<br class="d-sm-none" /><strong>{{ $report->car->number }}（@lang('db.report.alcohol_check-'.intval($report->alcohol_check))）</strong></p>
              </div>
              <div class="col-12 col-md-6">
                <p><span class="bi bi-sun me-2"></span>@lang('db.report.start')&nbsp;:&nbsp;<br class="d-sm-none" />
                  @if (empty($report->start_at) || empty($report->start_point) || empty($report->start_meter))
                  <a href="/report/{{ $report->id }}/edit?hash=report_start" class="text-warning fw-bold">
                    <span class="text-warning"><strong>＜未入力があります＞</strong></span>
                  </a>
                  @else
                  <strong>{{ date('G時i分', strtotime($report->start_at)) }}（{{ $report->start_point }}）</strong>
                  @endif
                </p>
              </div>
              <div class="col-12 col-md-6">
                <p><span class="bi bi-moon-stars me-2"></span>@lang('db.report.end')&nbsp;:&nbsp;<br class="d-sm-none" />
                  @if (empty($report->end_at) || empty($report->end_point) || empty($report->end_meter))
                  <a href="/report/{{ $report->id }}/edit?hash=report_end" class="text-warning fw-bold">
                    <span class="text-warning"><strong>＜乗務中＞</strong></span>
                  </a>
                  @else
                  <strong>@if(date('Ymd', strtotime($report->start_at)) !== date('Ymd', strtotime($report->end_at)))({{ date('j日', strtotime($report->end_at)) }})&nbsp;@endif{{ date('G時i分', strtotime($report->end_at)) }}（{{ $report->end_point }}）</strong>
                  @endif
                </p>
              </div>
              @if ($report->rests->count() > 0)
                @foreach($report->rests as $report_rest)
                  @if (empty($report_rest->end_at))
                  <div class="col-12 col-md-6">
                    <p><span class="bi bi-tree me-2"></span>@lang('db.report_rests_short')&nbsp;:&nbsp;<br class="d-sm-none" />
                      <a href="/report/{{ $report->id }}/rest/{{ $report_rest->id }}/edit" class="text-warning fw-bold">
                        <strong>{{ date('G時i分', strtotime($report_rest->start_at)) }}&nbsp;～＜休憩中＞</strong>
                      </a>
                    </p>
                  </div>
                  @endif
                @endforeach
              @endif
              <div class="col-6 col-md-4">
                <p><span class="bi bi-speedometer me-2"></span>@lang('db.report.start_meter')&nbsp;:&nbsp;<br class="d-sm-none" /><strong>{{ number_format($report->start_meter) }}&nbsp;@lang('system.unit.km')</strong></p>
              </div>
              <div class="col-6 col-md-4">
                <p><span class="bi bi-speedometer me-2"></span>@lang('db.report.end_meter')&nbsp;:&nbsp;<br class="d-sm-none" /><strong>{{ number_format($report->end_meter) }}&nbsp;@lang('system.unit.km')</strong></p>
              </div>
              <div class="col-6 col-md-4">
                <p><span class="bi bi-arrow-left-right me-2"></span>@lang('db.report.milage')&nbsp;:&nbsp;<br class="d-sm-none" /><strong>@if(!empty($report->end_meter)){{ number_format($report->end_meter - $report->start_meter) }}@else{{0}}@endif&nbsp;@lang('system.unit.km')</strong></p>
              </div>
              <div class="col-6 col-md-4">
                <p><span class="bi bi-droplet me-2"></span>@lang('db.report.light_oil')&nbsp;:&nbsp;<br class="d-sm-none" /><strong>{{ number_format($report->light_oil) }}&nbsp;@lang('system.unit.liter')</strong></p>
              </div>
              <div class="col-6 col-md-4">
                <p><span class="bi bi-droplet me-2"></span>@lang('db.report.adblue')&nbsp;:&nbsp;<br class="d-sm-none" /><strong>{{ number_format($report->adblue) }}&nbsp;@lang('system.unit.liter')</strong></p>
              </div>
              <div class="col-6 col-md-4">
                <p><span class="bi bi-droplet me-2"></span>@lang('db.report.adblue_handy')&nbsp;:&nbsp;<br class="d-sm-none" /><strong>{{ number_format($report->adblue_handy) }}&nbsp;@lang('system.unit.ko')</strong></p>
              </div>
              <div class="col-12 col-md-12">
                <p><span class="bi bi-chat-right-dots me-2"></span>@lang('db.report.note')&nbsp;:&nbsp;<br class="d-sm-none" /><strong>{{ $report->note }}</strong></p>
              </div>
            </div>
          </div>
          {{-- ショートカット --}}
          <div class="card bg-light mb-3">
            <div class="card-header h6">ショートカット</div>
            <div class="row">
              <div class="col-6 col-md-6">
                <div class="card-body pe-0">
                  <p class="card-text">
                    <a href="/report/{{ $report->id }}/edit?hash=report_oil" class="btn btn-xs btn-dark w-100 fw-bold">
                      <span class="bi bi-droplet-fill me-2"></span>
                      @lang('db.report.oil')
                    </a>
                  </p>
                </div>
              </div>
              <div class="col-6 col-md-6">
                <div class="card-body ps-0">
                  <p class="card-text">
                    <a href="/report/{{ $report->id }}/edit?hash=report_other" class="btn btn-xs btn-dark w-100 fw-bold">
                      <span class="bi bi-chat-right-dots-fill me-2"></span>
                      @lang('db.report.note')
                    </a>
                  </p>
                </div>
              </div>
            </div>
          </div>
          {{-- 経路コマンド --}}
          <div class="card bg-white mb-3">
            <div class="card-header h6">@lang('db.report_waypoints_short')（配車）</div>
            <div class="card-body pb-0 px-0">
              <p class="card-text px-3">
                <a href="/report/{{ $report->id }}/waypoint/create" class="btn btn-xs btn-info w-100 fw-bold">
                  <span class="container-fluid px-0">
                    <span class="row">
                      <span class="col-2 pe-0">
                      </span>
                      <span class="col-8 px-0">
                        <span class="bi bi-geo-alt-fill me-2"></span>
                        @lang('db.report_waypoints_short')を作成
                      </span>
                      <span class="col-2 ps-0 text-end">
                        @if ($report->waypoints->count() > 0)
                        <span class="badge rounded-pill bg-primary mt-1">{{ $report->waypoints->count() }}</span>
                        @endif
                      </span>
                    </span>
                  </span>
                </a>
              </p>
              <p class="card-text">
                <div class="table-responsive">
                  <table class="table table-hover text-nowrap">
                    <thead>
                      <tr>
                        <th class="text-center tb-col-icon-button">@lang('system.command.edit')</th>
                        <th class="text-start">@lang('db.report_waypoint.take_up')<span class="sort_button ms-2" data-sort="take_up"></span></th>
                        <th class="text-start">@lang('db.report_waypoint.take_down')<span class="sort_button ms-2" data-sort="take_down"></span></th>
                        <th class="text-start">@lang('db.report_waypoint.address')<span class="sort_button ms-2" data-sort="address"></span></th>
                        <th class="text-start">@lang('db.report_waypoint.item_name')<span class="sort_button ms-2" data-sort="item_name"></span></th>
                        <th class="text-end">@lang('db.report_waypoint.quantity')<span class="sort_button ms-2" data-sort="quantity"></span></th>
                        <th class="text-end">@lang('db.report_waypoint.unit_price')<span class="sort_button ms-2" data-sort="unit_price"></span></th>
                        <th class="text-start">@lang('db.report_waypoint.type_id')<span class="sort_button ms-2" data-sort="type_id"></span></th>
                        <th class="text-start">@lang('db.report_waypoint.billing_id')<span class="sort_button ms-2" data-sort="billing_id"></span></th>
                        <th class="text-start">@lang('db.report_waypoint.billing_disposal_name')<span class="sort_button ms-2" data-sort="billing_disposal_name"></span></th>
                        <th class="text-end">@lang('db.report_waypoint.highway_money')<span class="sort_button ms-2" data-sort="highway_money"></span></th>
                        <th class="text-start">@lang('db.report_waypoint.note')<span class="sort_button ms-2" data-sort="note"></span></th>
                        <th class="text-center tb-col-icon-button">@lang('system.command.delete')</th>
                      </tr>
                    </thead>
                    <tbody>
                      @foreach($report->waypoints as $report_waypoint)
                      <tr @if(!empty($report_waypoint->emergency))class="fw-bold bg-warning bg-opacity-10"@endif>
                        <td class="text-center tb-col-icon-button">
                          <a href="/report/{{ $report->id }}/waypoint/{{ $report_waypoint->id }}/edit" class="btn btn-xs btn-success"><span class="bi bi-pencil-fill"></span></a>
                        </td>
                        <td class="text-start">@if(!empty($report_waypoint->emergency))<span class="bi bi-info-circle-fill me-1 text-warning"></span>@endif{{ $report_waypoint->take_up }}</td>
                        <td class="text-start">{{ $report_waypoint->take_down }}</td>
                        <td class="text-start">{{ $report_waypoint->address }}</td>
                        <td class="text-start">{{ $report_waypoint->item_name }}</td>
                        <td class="text-end">@if(!empty($report_waypoint->quantity)){{ number_format($report_waypoint->quantity, 2) }}@if(!empty($report_waypoint->unit))&nbsp;{{ config('const.UNITS.'.$report_waypoint->unit) }}@endif @endif</td>
                        <td class="text-end">@if(!empty($report_waypoint->unit_price))@lang('system.unit.yen-mark'){{ number_format($report_waypoint->unit_price) }}@endif</td>
                        <td class="text-start">{{ $report_waypoint->type->name }}</td>
                        <td class="text-start">@if(!empty($report_waypoint->billing_id)){{ $report_waypoint->billing->name }}@endif</td>
                        <td class="text-start">{{ $report_waypoint->billing_disposal_name }}</td>
                        <td class="text-end">@if(!empty($report_waypoint->highway_money))@lang('system.unit.yen-mark'){{ number_format($report_waypoint->highway_money) }}@if($report_waypoint->highway_money > 0 && !empty($report_waypoint->highway_payment))&nbsp;&#40;{{ config('const.PAYMENTS.'.$report_waypoint->highway_payment) }}&#41;@endif @endif</td>
                        <td class="text-start"><span data-bs-toggle="tooltip" data-bs-placement="right" data-html="true" title="{{ $report_waypoint->note }}">{{ Str::limit($report_waypoint->note, 50) }}</span></td>
                        <td class="text-center tb-col-icon-button">
                          <form action="/report/{{ $report->id }}/waypoint/{{ $report_waypoint->id }}" method="post" class="mb-0">
                            @csrf
                            <input type="hidden" name="_method" value="DELETE">
                            <button type="submit" class="btn btn-xs btn-outline-danger" aria-label="Left Align" onClick="del_check(event);"><span class="bi bi-trash3"></span></button>
                          </form>
                        </td>
                      </tr>
                      @endforeach
                    </tbody>
                  </table>
                </div>
              </p>
            </div>
          </div>
          {{-- 同行コマンド --}}
          <div class="card bg-white mb-3">
            <div class="card-header h6">@lang('db.report_partners_short')</div>
            <div class="card-body pb-0 px-0">
              <p class="card-text px-3">
                <a href="/report/{{ $report->id }}/partner/create" class="btn btn-xs btn-info w-100 fw-bold">
                  <span class="container-fluid px-0">
                    <span class="row">
                      <span class="col-2 pe-0">
                      </span>
                      <span class="col-8 px-0">
                        <span class="bi bi-geo-alt-fill me-2"></span>
                        @lang('db.report_partners_short')を作成
                      </span>
                      <span class="col-2 ps-0 text-end">
                        @if ($report->partners->count() > 0)
                        <span class="badge rounded-pill bg-primary mt-1">{{ $report->partners->count() }}</span>
                        @endif
                      </span>
                    </span>
                  </span>
                </a>
              </p>
              <p class="card-text">
                <div class="table-responsive">
                  <table class="table table-hover text-nowrap">
                    <thead>
                      <tr>
                        <th class="text-center tb-col-icon-button">@lang('system.command.edit')</th>
                        <th class="text-start">@lang('db.report_partner.partner_id')<span class="sort_button ms-2" data-sort="partner_id"></span></th>
                        <th class="text-start">@lang('db.report_partner.company_name')<span class="sort_button ms-2"></span></th>
                        <th class="text-start">@lang('db.report_partner.quantity')<span class="sort_button ms-2" data-sort="quantity"></span></th>
                        <th class="text-start">@lang('db.report_partner.car_number')<span class="sort_button ms-2" data-sort="car_number"></span></th>
                        <th class="text-start">@lang('db.report_partner.item_name')<span class="sort_button ms-2" data-sort="item_name"></span></th>
                        <th class="text-start">@lang('db.report_partner.count')<span class="sort_button ms-2" data-sort="count"></span></th>
                        <th class="text-start">@lang('db.report_partner.take_down')<span class="sort_button ms-2" data-sort="take_down"></span></th>
                        <th class="text-center tb-col-icon-button">@lang('system.command.delete')</th>
                      </tr>
                    </thead>
                    <tbody>
                      @foreach($report->partners as $report_partner)
                      <tr>
                        <td class="text-center tb-col-icon-button">
                          <a href="/report/{{ $report->id }}/partner/{{ $report_partner->id }}/edit" class="btn btn-xs btn-success"><span class="bi bi-pencil-fill"></span></a>
                        </td>
                        <td class="text-start">{{ $report_partner->partner->name }}</td>
                        <td class="text-start">{{ $report_partner->partner->company_name }}</td>
                        <td class="text-start">{{ $report_partner->quantity }}@lang('system.unit.dai')</td>
                        <td class="text-start">{{ $report_partner->car_number }}</td>
                        <td class="text-start">{{ $report_partner->item_name }}</td>
                        <td class="text-start">{{ $report_partner->count }}</td>
                        <td class="text-start">{{ $report_partner->take_down }}</td>
                        <td class="text-center tb-col-icon-button">
                          <form action="/report/{{ $report->id }}/partner/{{ $report_partner->id }}" method="post" class="mb-0">
                            @csrf
                            <input type="hidden" name="_method" value="DELETE">
                            <button type="submit" class="btn btn-xs btn-outline-danger" aria-label="Left Align" onClick="del_check(event);"><span class="bi bi-trash3"></span></button>
                          </form>
                        </td>
                      </tr>
                      @endforeach
                    </tbody>
                  </table>
                </div>
              </p>
            </div>
          </div>
          {{-- 休憩コマンド --}}
          <div class="card bg-white mb-3">
            <div class="card-header h6">@lang('db.report_rests_short')</div>
            <div class="card-body pb-0 px-0">
              <p class="card-text px-3">
                <a href="/report/{{ $report->id }}/rest/create" class="btn btn-xs btn-info w-100 fw-bold">
                  <span class="container-fluid px-0">
                    <span class="row">
                      <span class="col-2 pe-0">
                      </span>
                      <span class="col-8 px-0">
                        <span class="bi bi-geo-alt-fill me-2"></span>
                        @lang('db.report_rests_short')を作成
                      </span>
                      <span class="col-2 ps-0 text-end">
                        @if ($report->rests->count() > 0)
                        <span class="badge rounded-pill bg-primary mt-1">{{ $report->rests->count() }}</span>
                        @endif
                      </span>
                    </span>
                  </span>
                </a>
              </p>
              <p class="card-text">
                <div class="table-responsive">
                  <table class="table table-hover text-nowrap">
                    <thead>
                      <tr>
                        <th class="text-center tb-col-icon-button">@lang('system.command.edit')</th>
                        <th class="text-start">@lang('db.report_rest.point')<span class="sort_button ms-2" data-sort="point"></span></th>
                        <th class="text-start">@lang('db.report_rest.start_at')<span class="sort_button ms-2" data-sort="start_at"></span></th>
                        <th class="text-start">@lang('db.report_rest.end_at')<span class="sort_button ms-2" data-sort="end_at"></span></th>
                        <th class="text-center tb-col-icon-button">@lang('system.command.delete')</th>
                      </tr>
                    </thead>
                    <tbody>
                      @foreach($report->rests as $report_rest)
                      <tr>
                        <td class="text-center tb-col-icon-button">
                          <a href="/report/{{ $report->id }}/rest/{{ $report_rest->id }}/edit" class="btn btn-xs btn-success"><span class="bi bi-pencil-fill"></span></a>
                        </td>
                        <td class="text-start">{{ $report_rest->point }}</td>
                        <td class="text-start">@if(!empty($report_rest->start_at)){{ date('G時i分', strtotime($report_rest->start_at)) }}@endif</td>
                        <td class="text-start">@if(!empty($report_rest->end_at)){{ date('G時i分', strtotime($report_rest->end_at)) }}@endif</td>
                        <td class="text-center tb-col-icon-button">
                          <form action="/report/{{ $report->id }}/rest/{{ $report_rest->id }}" method="post" class="mb-0">
                            @csrf
                            <input type="hidden" name="_method" value="DELETE">
                            <button type="submit" class="btn btn-xs btn-outline-danger" aria-label="Left Align" onClick="del_check(event);"><span class="bi bi-trash3"></span></button>
                          </form>
                        </td>
                      </tr>
                      @endforeach
                    </tbody>
                  </table>
                </div>
              </p>
            </div>
          </div>
        </div>
      </div>
    </div>
    @endforeach
    {{-- 日報新規作成（2回目以降） --}}
    <div class="col-12 col-md-6">
      <div class="card border-secondary mb-3">
        <div class="card-header">今日の他の@lang('db.reports')</div>
        <div class="card-body">
          <p class="card-text text-muted">他の@lang('db.reports')が必要な場合はコチラから作成してください。</p>
          <p class="card-text">
            <a href="/report/create" class="btn btn-xs btn-primary w-100 fw-bold">
              <span class="bi bi-plus-square me-2"></span>
              @lang('db.reports') @lang('system.command.create')
            </a>
          </p>
        </div>
      </div>
    </div>
  </div>
@else
  {{-- 日報新規作成（初回） --}}
  <div class="row">
    <div class="col-12 col-md-6">
      <div class="card border-primary mb-3">
        <div class="card-header">今日の@lang('db.reports')</div>
        <div class="card-body">
          <p class="card-text text-primary">コチラから新しい@lang('db.reports')を作成してください。</p>
          <p class="card-text">
            <a href="/report/create" class="btn btn-xs btn-primary w-100 fw-bold">
              <span class="bi bi-plus-square me-2"></span>
              @lang('db.reports') @lang('system.command.create')
            </a>
          </p>
        </div>
      </div>
    </div>
  </div>
@endif
</div>
<script>
  let tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
  let tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
    return new bootstrap.Tooltip(tooltipTriggerEl);
  });
</script>
@endsection
@include('common/script-del_check')
