<div class="container-fluid px-0">
  <div class="row text-center mb-3">
    <div class="col">
      @if($target == 'store')
      <h1 class="h2">@lang('db.partners') @lang('system.title.create')</h1>
      @elseif($target == 'update')
      <h1 class="h2">@lang('db.partners') @lang('system.title.edit')</h1>
      @endif
    </div>
  </div>
  @if($target == 'store')
  <form action="/partner" method="post" onsubmit="return submitForm()">
  @elseif($target == 'update')
  <form action="/partner/{{ $partner->id }}" name="" method="post" onsubmit="return submitForm()">
    <input type="hidden" name="_method" value="PUT">
  @endif
    @csrf
    <div class="row justify-content-center">
      <div class="col-12 col-md-8 col-lg-6">{{-- Set Input Form Size --}}
        @include('common/error-message')
        <div class="card border-secondary mb-3 w-100">
          <div class="card-header mb-2">@lang('db.partners') @lang('system.title.information')</div>
          <div class="card-body">
            <div class="form-group mb-4">
              <label class="form-label mb-2">@lang('db.partner.name')</label>
              <input type="text" class="form-control @error('name') is-invalid @enderror" name="name" placeholder="" value="{{ old('name', $partner->name) }}">
              @error('name')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
            </div>
            <div class="form-group mb-4">
              <label class="form-label mb-2">@lang('db.partner.company_name')</label>
              <input type="text" class="form-control @error('company_name') is-invalid @enderror" name="company_name" placeholder="" value="{{ old('company_name', $partner->company_name) }}">
              @error('company_name')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
            </div>
            <div class="form-group mb-4">
              <label class="form-label mb-2">@lang('db.partner.quantity')</label>
              <div class="input-group @error('quantity') is-invalid @enderror">
                <input type="number" class="form-control @error('quantity') is-invalid @enderror" name="quantity" value="{{ old('quantity', $partner->quantity) }}">
                <span class="input-group-text">@lang('system.unit.dai')</span>
              </div>
              @error('quantity')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
            </div>
            <div class="form-group mb-4">
              <label class="form-label mb-2">@lang('db.partner.note')</label>
              <textarea class="form-control @error('note') is-invalid @enderror" id="exampleTextarea" rows="3" name="note">{{ old('note', $partner->note) }}</textarea>
              @error('note')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="row justify-content-center mb-4">
      <div class="col-12 col-md-5 col-lg-4 mt-2 mb-2">{{-- Not Change --}}
        <button type="submit" id="submit-button" class="btn btn-primary w-100"><span class="bi bi-check-circle me-2"></span>@lang('system.command.register')</button>
      </div>
      <div class="col-12 col-md-3 col-lg-2 mt-2 mb-2">
        @if (session()->has('checkpoint'))
        <a href="{{ session()->get('checkpoint') }}" class="btn btn-outline-primary w-100"><span class="bi bi-caret-left me-1"></span>@lang('system.command.back')</a>
        @else
        <a href="./" class="btn btn-outline-primary w-100"><span class="bi bi-caret-left me-1"></span>@lang('system.command.back')</a>
        @endif
      </div>
    </div>
  </form>
</div>
@include('common/script-form')
