<div class="container-fluid px-0">
  <div class="row text-center mb-3">
    <div class="col">
      <h1 class="h2">@lang('db.reports') @lang('system.title.show')</h1>
    </div>
  </div>
  <div class="row">
    <div class="col">
      <div class="card border-secondary mb-3 w-100">
        <div class="card-header mb-2">@lang('db.reports') @lang('system.title.information')</div>
        <div class="card-body">
          <div class="container-fluid p-0 m-0">
            <div class="row">
              <div class="col-12 col-md-6">
                <p>@lang('db.report.user_id')&nbsp;:&nbsp;<br class="d-sm-none" /><strong>{{ $report->user->name }}</strong></p>
              </div>
              <div class="col-12 col-md-6">
                <p>@lang('db.report.car_id')&nbsp;:&nbsp;<br class="d-sm-none" /><strong>{{ $report->car->number }}（@lang('db.report.alcohol_check-'.intval($report->alcohol_check))）</strong></p>
              </div>
              <div class="col-12 col-md-6">
                <p>@lang('db.report.start')&nbsp;:&nbsp;<br class="d-sm-none" /><strong>{{ date('Y年n月j日 G時i分', strtotime($report->start_at)) }}（{{ $report->start_point }}）</strong></p>
              </div>
              <div class="col-12 col-md-6">
                <p>@lang('db.report.end')&nbsp;:&nbsp;<br class="d-sm-none" /><strong>@if(!empty($report->end_at)){{ date('Y年n月j日 G時i分', strtotime($report->end_at)) }}@endif（{{ $report->end_point }}）</strong></p>
              </div>
              <div class="col-6 col-md-4">
                <p>@lang('db.report.start_meter')&nbsp;:&nbsp;<br class="d-sm-none" /><strong>{{ number_format($report->start_meter) }}&nbsp;@lang('system.unit.km')</strong></p>
              </div>
              <div class="col-6 col-md-4">
                <p>@lang('db.report.end_meter')&nbsp;:&nbsp;<br class="d-sm-none" /><strong>{{ number_format($report->end_meter) }}&nbsp;@lang('system.unit.km')</strong></p>
              </div>
              <div class="col-6 col-md-4">
                <p>@lang('db.report.milage')&nbsp;:&nbsp;<br class="d-sm-none" /><strong>@if(!empty($report->end_meter)){{ number_format($report->end_meter - $report->start_meter) }}@else{{0}}@endif&nbsp;@lang('system.unit.km')</strong></p>
              </div>
              <div class="col-6 col-md-4">
                <p>@lang('db.report.light_oil')&nbsp;:&nbsp;<br class="d-sm-none" /><strong>{{ number_format($report->light_oil) }}&nbsp;@lang('system.unit.liter')</strong></p>
              </div>
              <div class="col-6 col-md-4">
                <p>@lang('db.report.adblue')&nbsp;:&nbsp;<br class="d-sm-none" /><strong>{{ number_format($report->adblue) }}&nbsp;@lang('system.unit.liter')</strong></p>
              </div>
              <div class="col-6 col-md-4">
                <p>@lang('db.report.adblue_handy')&nbsp;:&nbsp;<br class="d-sm-none" /><strong>{{ number_format($report->adblue_handy) }}&nbsp;@lang('system.unit.ko')</strong></p>
              </div>
              <div class="col-12 col-md-12">
                <p>@lang('db.report.note')&nbsp;:&nbsp;<br class="d-sm-none" /><strong>{{ $report->note }}</strong></p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="row mt-2">
    <div class="col">
      <div class="card border-secondary mb-3 w-100">
        <div class="card-header mb-2">@lang('db.report_waypoints') @lang('system.title.index')</div>
        <div class="card-body pt-1 pb-2">
          @if ($report->waypoints->count() > 0)
          <div class="table-responsive">
            <table class="table table-hover text-nowrap">
              <thead>
                <tr>
                  <th class="text-start">@lang('db.report_waypoint.take_up')<span class="sort_button ms-2" data-sort="take_up"></span></th>
                  <th class="text-start">@lang('db.report_waypoint.take_down')<span class="sort_button ms-2" data-sort="take_down"></span></th>
                  <th class="text-start">@lang('db.report_waypoint.address')<span class="sort_button ms-2" data-sort="address"></span></th>
                  <th class="text-start">@lang('db.report_waypoint.item_name')<span class="sort_button ms-2" data-sort="item_name"></span></th>
                  <th class="text-end">@lang('db.report_waypoint.quantity')<span class="sort_button ms-2" data-sort="quantity"></span></th>
                  <th class="text-end">@lang('db.report_waypoint.unit_price')<span class="sort_button ms-2" data-sort="unit_price"></span></th>
                  <th class="text-start">@lang('db.report_waypoint.type_id')<span class="sort_button ms-2" data-sort="type_id"></span></th>
                  <th class="text-start">@lang('db.report_waypoint.billing_id')<span class="sort_button ms-2" data-sort="billing_id"></span></th>
                  <th class="text-start">@lang('db.report_waypoint.billing_disposal_name')<span class="sort_button ms-2" data-sort="billing_disposal_name"></span></th>
                  <th class="text-end">@lang('db.report_waypoint.highway_money')<span class="sort_button ms-2" data-sort="highway_money"></span></th>
                  <th class="text-start">@lang('db.report_waypoint.note')<span class="sort_button ms-2" data-sort="note"></span></th>
                </tr>
              </thead>
              <tbody>
                @foreach($report->waypoints as $report_waypoint)
                <tr>
                  <td class="text-start">@if(!empty($report_waypoint->emergency))<span class="bi bi-info-circle-fill me-1 text-warning"></span>@endif{{ $report_waypoint->take_up }}</td>
                  <td class="text-start">{{ $report_waypoint->take_down }}</td>
                  <td class="text-start">{{ $report_waypoint->address }}</td>
                  <td class="text-start">{{ $report_waypoint->item_name }}</td>
                  <td class="text-end">@if(!empty($report_waypoint->quantity)){{ number_format($report_waypoint->quantity, 2) }}@if(!empty($report_waypoint->unit))&nbsp;{{ config('const.UNITS.'.$report_waypoint->unit) }}@endif @endif</td>
                  <td class="text-end">@if(!empty($report_waypoint->unit_price))@lang('system.unit.yen-mark'){{ number_format($report_waypoint->unit_price) }}@endif</td>
                  <td class="text-start">{{ $report_waypoint->type->name }}</td>
                  <td class="text-start">@if(!empty($report_waypoint->billing_id)){{ $report_waypoint->billing->name }}@endif</td>
                  <td class="text-start">{{ $report_waypoint->billing_disposal_name }}</td>
                  <td class="text-end">@if(!empty($report_waypoint->highway_money))@lang('system.unit.yen-mark'){{ number_format($report_waypoint->highway_money) }}@if($report_waypoint->highway_money > 0 && !empty($report_waypoint->highway_payment))&nbsp;&#40;{{ config('const.PAYMENTS.'.$report_waypoint->highway_payment) }}&#41;@endif @endif</td>
                  <td class="text-start"><span data-bs-toggle="tooltip" data-bs-placement="right" data-html="true" title="{{ $report_waypoint->note }}">{{ Str::limit($report_waypoint->note, 50) }}</span></td>
                </tr>
                @endforeach
              </tbody>
            </table>
          </div>
          @endif
        </div>
      </div>
    </div>
  </div>
  <div class="row mt-2">
    <div class="col">
      <div class="card border-secondary mb-3 w-100">
        <div class="card-header mb-2">@lang('db.report_partners') @lang('system.title.index')</div>
        <div class="card-body pt-1 pb-2">
          @if ($report->partners->count() > 0)
          <div class="table-responsive">
            <table class="table table-hover text-nowrap">
              <thead>
                <tr>
                  <th class="text-start">@lang('db.report_partner.partner_id')<span class="sort_button ms-2" data-sort="partner_id"></span></th>
                  <th class="text-start">@lang('db.report_partner.company_name')<span class="sort_button ms-2"></span></th>
                  <th class="text-start">@lang('db.report_partner.quantity')<span class="sort_button ms-2" data-sort="quantity"></span></th>
                  <th class="text-start">@lang('db.report_partner.car_number')<span class="sort_button ms-2" data-sort="car_number"></span></th>
                  <th class="text-start">@lang('db.report_partner.item_name')<span class="sort_button ms-2" data-sort="item_name"></span></th>
                  <th class="text-start">@lang('db.report_partner.count')<span class="sort_button ms-2" data-sort="count"></span></th>
                  <th class="text-start">@lang('db.report_partner.take_down')<span class="sort_button ms-2" data-sort="take_down"></span></th>
                </tr>
              </thead>
              <tbody>
                @foreach($report->partners as $report_partner)
                <tr>
                  <td class="text-start">{{ $report_partner->partner->name }}</td>
                  <td class="text-start">{{ $report_partner->partner->company_name }}</td>
                  <td class="text-start">{{ $report_partner->quantity }}@lang('system.unit.dai')</td>
                  <td class="text-start">{{ $report_partner->car_number }}</td>
                  <td class="text-start">{{ $report_partner->item_name }}</td>
                  <td class="text-start">{{ $report_partner->count }}</td>
                  <td class="text-start">{{ $report_partner->take_down }}</td>
                </tr>
                @endforeach
              </tbody>
            </table>
          </div>
          @endif
        </div>
      </div>
    </div>
  </div>
  <div class="row mt-2">
    <div class="col">
      <div class="card border-secondary mb-3 w-100">
        <div class="card-header mb-2">@lang('db.report_rests') @lang('system.title.index')</div>
        <div class="card-body pt-1 pb-2">
          @if ($report->rests->count() > 0)
          <div class="table-responsive">
            <table class="table table-hover text-nowrap">
              <thead>
                <tr>
                  <th class="text-start">@lang('db.report_rest.point')<span class="sort_button ms-2" data-sort="point"></span></th>
                  <th class="text-start">@lang('db.report_rest.start_at')<span class="sort_button ms-2" data-sort="start_at"></span></th>
                  <th class="text-start">@lang('db.report_rest.end_at')<span class="sort_button ms-2" data-sort="end_at"></span></th>
                </tr>
              </thead>
              <tbody>
                @foreach($report->rests as $report_rest)
                <tr>
                  <td class="text-start">{{ $report_rest->point }}</td>
                  <td class="text-start">@if(!empty($report_rest->start_at)){{ date('G時i分', strtotime($report_rest->start_at)) }}@endif</td>
                  <td class="text-start">@if(!empty($report_rest->end_at)){{ date('G時i分', strtotime($report_rest->end_at)) }}@endif</td>
                </tr>
                @endforeach
              </tbody>
            </table>
          </div>
      @endif
        </div>
      </div>
    </div>
  </div>
  <div class="row text-center mb-4 mt-4">
    <div class="d-none d-md-block col-md-4">
    </div>
    <div class="col-12 col-md-4">
      @if (session()->has('checkpoint'))
        <a href="{{ session()->get('checkpoint') }}" class="btn btn-outline-primary w-100 mb-2"><span class="bi bi-caret-left me-1"></span>@lang('system.command.back')</a>
        @else
        <a href="./" class="btn btn-outline-primary w-100 mb-2"><span class="bi bi-caret-left me-1"></span>@lang('system.command.back')</a>
      @endif
    </div>
  </div>
</div>
<script>
  let tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
  let tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
    return new bootstrap.Tooltip(tooltipTriggerEl);
  });
</script>
