<div class="container-fluid px-0">
  <div class="row text-center mb-3">
    <div class="col">
      @if($target == 'store')
      <h1 class="h2">@lang('db.reports') @lang('system.title.create')</h1>
      @elseif($target == 'update')
      <h1 class="h2">@lang('db.reports') @lang('system.title.edit')</h1>
      @endif
    </div>
  </div>
  @if($target == 'store')
  <form action="/report" method="post" onsubmit="return submitForm()">
  @elseif($target == 'update')
  <form action="/report/{{ $report->id }}" name="" method="post" onsubmit="return submitForm()">
    <input type="hidden" name="_method" value="PUT">
  @endif
    @csrf
    <div class="row justify-content-center">
      <div class="col-12 col-md-12 col-lg-12">{{-- Set Input Form Size --}}
        @include('common/error-message')
        <div class="card border-secondary mb-3 w-100">
          <div class="card-header mb-2">@lang('db.reports') @lang('system.title.information')</div>
          <div class="card-body">
            <div class="container-fluid p-0 m-0">
            <div class="row">
                <div class="col-12 col-md-6">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report.user_id')</label>
                    <select class="form-select @error('user_id') is-invalid @enderror" name="user_id">
                      @php
                        $old_user_id = '';
                        if ($target == 'store') {
                          $old_user_id = Auth::user()->id;
                        } else {
                          $old_user_id = $report->user_id;
                        }
                      @endphp
                      @foreach ($users as $user)
                        <option value="{{ $user->id }}" @if(old('user_id', $old_user_id)==$user->id) selected  @endif>{{ $user->name }}</option>
                      @endforeach
                    </select>
                    @error('user_id')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                  </div>
                </div>
                <div class="col-12 col-md-6">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report.car_id')</label>
                    <select class="form-select @error('car_id') is-invalid @enderror" name="car_id">
                      @php
                        $old_car_id = '';
                        if ($target == 'store') {
                          $old_car_id = Auth::user()->car_id;
                        } else {
                          $old_car_id = $report->car_id;
                        }
                      @endphp
                      @foreach ($cars as $car)
                        <option value="{{ $car->id }}" @if(old('car_id', $old_car_id)==$car->id) selected  @endif>{{ $car->number }}</option>
                      @endforeach
                    </select>
                    <div class="form-text">@lang('db.car.use')が「@lang('db.car.use-1')」のみ表示されています</div>
                    @error('car_id')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                  </div>            
                </div>
              </div>
            </div>
          </div>
        </div>
        <div id="report_start" class="container-fluid p-0 m-0">
          <div class="row justify-content-center mb-3">
            <div class="col-12 col-md-5 col-lg-4 mt-2 mb-2">
              <button type="submit" id="submit-button" class="btn btn-dark w-100"><span class="bi bi-check-circle me-2"></span>@lang('system.command.in_the_middle')</button>
            </div>
          </div>
        </div>
        <div class="card border-secondary mb-3 w-100">
          <div class="card-header mb-2">@lang('db.report.start') @lang('system.title.information')</div>
          <div class="card-body">
            <div class="container-fluid p-0 m-0">
              <div class="row">
                <div class="col-12 col-md-6">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report.start_point')</label>
                    @php
                      $old_start_point = '';
                      if ($target == 'store') {
                        $old_start_point = '弥富車庫';
                      } else {
                        $old_start_point = $report->start_point;
                      }
                    @endphp
                    <input type="text" class="form-control @error('start_point') is-invalid @enderror" name="start_point" placeholder="" value="{{ old('start_point', $old_start_point) }}">
                    @error('start_point')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                  </div>
                </div>
                <div class="col-12 col-md-6">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report.start_at')</label>
                    @php
                      $old_start_at = '';
                      if ($target == 'store') {
                        if (empty($params['start_at'])) {
                          $old_start_at = date('Y-m-d\TH:i');
                        } else {
                          $old_start_at = $params['start_at'].'T00:00';
                        }
                      } else {
                        $old_start_at = date('Y-m-d\TH:i', strtotime($report->start_at));
                      }
                    @endphp
                    <input type="datetime-local" class="form-control @error('start_at') is-invalid @enderror" name="start_at" placeholder="" value="{{ old('start_at', $old_start_at) }}">
                    @error('start_at')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-12 col-md-6">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report.start_meter')</label>
                    <div class="input-group @error('start_meter') is-invalid @enderror">
                      <input type="number" id="start_meter" class="form-control @error('start_meter') is-invalid @enderror" name="start_meter" placeholder="" value="{{ old('start_meter', $report->start_meter) }}" onchange="calcMileage()">
                      <span class="input-group-text">@lang('system.unit.km')</span>
                    </div>
                    @error('start_meter')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                  </div>
                </div>
                <div class="col-12 col-md-6">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report.alcohol_check')</label>
                    <div class="form-check @error('alcohol_check') is-invalid @enderror mt-1">
                      <label class="form-check-label">
                        <input type="checkbox" class="form-check-input @error('alcohol_check') is-invalid @enderror" name="alcohol_check" value="1" @if(old('alcohol_check', $report->alcohol_check) == '1') checked @endif>
                        @lang('db.report.alcohol_check-1')
                      </label>
                    </div>
                    @error('alcohol_check')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div id="report_end" class="container-fluid p-0 m-0">
          <div class="row justify-content-center mb-3">
            <div class="col-12 col-md-5 col-lg-4 mt-2 mb-2">
              <button type="submit" id="submit-button" class="btn btn-dark w-100"><span class="bi bi-check-circle me-2"></span>@lang('system.command.in_the_middle')</button>
            </div>
          </div>
        </div>
        <div class="card border-secondary mb-3 w-100">
          <div class="card-header mb-2">@lang('db.report.end') @lang('system.title.information')</div>
          <div class="card-body">
            <div class="container-fluid p-0 m-0">
              <div class="row">
                <div class="col-12 col-md-6">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report.end_point')</label>
                    @php
                      $old_end_point = '';
                      if ($target == 'store') {
                        $old_end_point = '弥富車庫';
                      } else {
                        $old_end_point = $report->end_point;
                      }
                    @endphp
                    <input type="text" class="form-control @error('end_point') is-invalid @enderror" name="end_point" placeholder="" value="{{ old('end_point', $old_end_point) }}">
                    @error('end_point')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                  </div>
                </div>
                <div class="col-12 col-md-6">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report.end_at')</label>
                    @php
                      $old_end_at = '';
                      if ($target == 'update' && !empty($report->end_at)) {
                        $old_end_at = date('Y-m-d\TH:i', strtotime($report->end_at));
                      }
                    @endphp
                    <input type="datetime-local" class="form-control @error('end_at') is-invalid @enderror" name="end_at" placeholder="" value="{{ old('end_at', $old_end_at) }}">
                    @error('end_at')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-12 col-md-6">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report.end_meter')</label>
                    <div class="input-group @error('end_meter') is-invalid @enderror">
                      <input type="number" id="end_meter" class="form-control @error('end_meter') is-invalid @enderror" name="end_meter" placeholder="" value="{{ old('end_meter', $report->end_meter) }}" onchange="calcMileage()">
                      <span class="input-group-text">@lang('system.unit.km')</span>
                    </div>
                    @error('end_meter')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                  </div>
                </div>
                <div class="col-12 col-md-6">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report.milage')</label>
                    <input type="text" id="mileage" class="form-control" name="" placeholder="" value="" readonly>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div id="report_oil" class="container-fluid p-0 m-0">
          <div class="row justify-content-center mb-3">
            <div class="col-12 col-md-5 col-lg-4 mt-2 mb-2">
              <button type="submit" id="submit-button" class="btn btn-dark w-100"><span class="bi bi-check-circle me-2"></span>@lang('system.command.in_the_middle')</button>
            </div>
          </div>
        </div>
        <div class="card border-secondary mb-3 w-100">
          <div class="card-header mb-2">@lang('db.report.oil') @lang('system.title.information')</div>
          <div class="card-body">
            <div class="container-fluid p-0 m-0">
              <div class="row">
                <div class="col-12 col-md-4">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report.light_oil')</label>
                    <div class="input-group @error('light_oil') is-invalid @enderror">
                      <input type="number" class="form-control @error('light_oil') is-invalid @enderror" name="light_oil" placeholder="" value="{{ old('light_oil', $report->light_oil) }}">
                      <span class="input-group-text">&nbsp;@lang('system.unit.liter')</span>
                    </div>
                    @error('light_oil')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                  </div>
                </div>
                <div class="col-12 col-md-4">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report.adblue')</label>
                    <div class="input-group @error('adblue') is-invalid @enderror">
                      <input type="number" class="form-control @error('adblue') is-invalid @enderror" name="adblue" placeholder="" value="{{ old('adblue', $report->adblue) }}">
                      <span class="input-group-text">&nbsp;@lang('system.unit.liter')</span>
                    </div>
                    @error('adblue')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                  </div>
                </div>
                <div class="col-12 col-md-4">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report.adblue_handy')</label>
                    <div class="input-group @error('adblue_handy') is-invalid @enderror">
                      <input type="number" class="form-control @error('adblue_handy') is-invalid @enderror" name="adblue_handy" placeholder="" value="{{ old('adblue_handy', $report->adblue_handy) }}">
                      <span class="input-group-text">&nbsp;@lang('system.unit.ko')</span>
                    </div>
                    @error('adblue_handy')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div id="report_other" class="container-fluid p-0 m-0">
          <div class="row justify-content-center mb-3">
            <div class="col-12 col-md-5 col-lg-4 mt-2 mb-2">
              <button type="submit" id="submit-button" class="btn btn-dark w-100"><span class="bi bi-check-circle me-2"></span>@lang('system.command.in_the_middle')</button>
            </div>
          </div>
        </div>
        <div class="card border-secondary mb-3 w-100">
          <div class="card-header mb-2">@lang('db.report.other') @lang('system.title.information')</div>
          <div class="card-body">
            <div class="container-fluid p-0 m-0">
              <div class="row">
                <div class="col">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report.note')</label>
                    <textarea class="form-control @error('note') is-invalid @enderror" id="exampleTextarea" rows="5" name="note">{{ old('note', $report->note) }}</textarea>
                    @error('note')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="row justify-content-center mb-4">
      <div class="col-12 col-md-5 col-lg-4 mt-2 mb-2">{{-- Not Change --}}
        <button type="submit" id="submit-button" class="btn btn-primary w-100"><span class="bi bi-check-circle me-2"></span>@lang('system.command.register')</button>
      </div>
      <div class="col-12 col-md-3 col-lg-2 mt-2 mb-2">
        @if (session()->has('checkpoint'))
        <a href="{{ session()->get('checkpoint') }}" class="btn btn-outline-primary w-100"><span class="bi bi-caret-left me-1"></span>@lang('system.command.back')</a>
        @else
        <a href="./" class="btn btn-outline-primary w-100"><span class="bi bi-caret-left me-1"></span>@lang('system.command.back')</a>
        @endif
      </div>
    </div>
  </form>
</div>
@include('common/script-form')
<script>
    window.addEventListener('load', function() {
      calcMileage();
    }, false);

    function calcMileage() {
      let start_meter = document.getElementById('start_meter');
      let end_meter = document.getElementById('end_meter');
      let mileage = document.getElementById('mileage');
      if (start_meter.value != '' && end_meter.value != '') {
        mileage.value = Number(end_meter.value) - Number(start_meter.value);
      }
    }

    @if (!empty($params['hash']))
    window.addEventListener('DOMContentLoaded', () => {
      const targetId = '{{ $params['hash'] }}';
      const targetElement = document.getElementById(targetId);
      const targetOffsetTop = window.pageYOffset + targetElement.getBoundingClientRect().top;
      window.scrollTo({
        top: targetOffsetTop,
        behavior: "smooth"
      });
    });
    @endif
</script>