@extends('common/main/layout')
@section('content')
<div class="container-fluid px-0">
  <div class="row mb-3">
    <div class="col">
      <h1 class="h2">@lang('db.reports') @lang('system.title.index')</h1>
    </div>
  </div>
  @include('common/error-message')
  <div class="row">
    <div class="col-12 col-md">
      <a href="/report/create" class="btn btn-primary m-2"><span class="bi bi-plus-square me-2"></span>@lang('system.command.create')</a>
    </div>
    <div class="col col-md p-2">
      <select id="search_user_id" class="form-select" name="user_id">
        <option value="all">すべて表示</option>
        @foreach ($users as $user)
          <option value="{{ $user->id }}" @if($params['user_id'] == $user->id) selected  @endif>{{ $user->name }}</option>
        @endforeach
      </select>
    </div>
    <div class="col-12 col-md p-2">
      <input type="month" id="search_start_at" class="form-control" name="start_at" placeholder="" value="{{ old('start_at', date('Y-m', strtotime($params['start_at']))) }}">
    </div>
  </div>
  <div class="row">
    <div class="col">
      <div class="table-responsive">
        <table class="table table-hover text-nowrap">
          <thead>
            <tr>
              <th class="text-center tb-col-icon-button">@lang('system.command.edit')</th>
              <th class="text-start">@lang('db.report.start_at')&nbsp;&#65374;&nbsp;@lang('db.report.end_at')<span class="sort_button ms-2" data-sort="start_at"></span></th>
              <th class="text-center tb-col-icon-button">@lang('db.report_waypoints_short')</th>
              <th class="text-center tb-col-icon-button">@lang('db.report_partners_short')</th>
              <th class="text-center tb-col-icon-button">@lang('db.report_rests_short')</th>
              <th class="text-center tb-col-icon-button">@lang('system.command.show')</th>
              <th class="text-start">@lang('db.report.start_point')<span class="sort_button ms-2" data-sort="start_point"></span></th>
              <th class="text-start">@lang('db.report.end_point')<span class="sort_button ms-2" data-sort="end_point"></span></th>
              <th class="text-start">@lang('db.report.user_id')<span class="sort_button ms-2" data-sort="user_id"></span></th>
              <th class="text-start">@lang('db.report.car_id')<span class="sort_button ms-2" data-sort="car_id"></span></th>
              <th class="text-center tb-col-icon-button">@lang('system.command.delete')</th>
            </tr>
          </thead>
          <tbody>
            @foreach($reports as $report)
            <tr>
              <td class="text-center tb-col-icon-button">
                <a href="/report/{{ $report->id }}/edit" class="btn btn-xs btn-success"><span class="bi bi-pencil-fill"></span></a>
              </td>
              <td class="text-start">
                <span class="text-primary me-3 fw-bold">{{ date('j日', strtotime($report->start_at)) }}</span>{{ date('G時i分', strtotime($report->start_at)) }}
                &nbsp;&#65374;&nbsp;
                @if(!empty($report->end_at))@if(date('Ymd', strtotime($report->start_at)) !== date('Ymd', strtotime($report->end_at)))({{ date('j日', strtotime($report->end_at)) }})&nbsp;@endif{{ date('G時i分', strtotime($report->end_at)) }}@endif
              </td>
              <td class="text-center tb-col-icon-button">
                <div class="position-relative">
                  <a href="/report/{{ $report->id }}/waypoint" class="btn btn-xs btn-info"><span class="bi bi-geo-alt-fill"></span></a>
                  @if ($report->waypoints->count() > 0)
                  <span class="badge rounded-pill bg-primary badge-from-btn">{{ $report->waypoints->count() }}</span>
                  @endif
                </div>
              </td>
              <td class="text-center tb-col-icon-button">
                <div class="position-relative">
                  <a href="/report/{{ $report->id }}/partner" class="btn btn-xs btn-info"><span class="bi bi-people-fill"></span></a>
                  @if ($report->partners->count() > 0)
                  <span class="badge rounded-pill bg-primary badge-from-btn">{{ $report->partners->count() }}</span>
                  @endif
                </div>
              </td>
              <td class="text-center tb-col-icon-button">
                <div class="position-relative">
                  <a href="/report/{{ $report->id }}/rest" class="btn btn-xs btn-info"><span class="bi bi-tree-fill"></span></a>
                  @if ($report->rests->count() > 0)
                  <span class="badge rounded-pill bg-primary badge-from-btn">{{ $report->rests->count() }}</span>
                  @endif
                </div>
              </td>
              <td class="text-center tb-col-icon-button">
                <a href="/report/{{ $report->id }}" class="btn btn-xs btn-primary"><span class="bi bi-stickies-fill"></span></a>
              </td>
              <td class="text-start">{{ $report->start_point }}</td>
              <td class="text-start">{{ $report->end_point }}</td>
              <td class="text-start">{{ $report->user->name }}</td>
              <td class="text-start">{{ $report->car->number }}</td>
              <td class="text-center tb-col-icon-button">
                <form action="/report/{{ $report->id }}" method="post">
                  @csrf
                  <input type="hidden" name="_method" value="DELETE">
                  <button type="submit" class="btn btn-xs btn-outline-danger" aria-label="Left Align" onClick="del_check(event);"><span class="bi bi-trash3"></span></button>
                </form>
              </td>
            </tr>
            @endforeach
          </tbody>
        </table>
      </div>
    </div>
  </div>
  @include('common/pagination', ['tables' => $reports])
</div>
@include('common/script-sort')
@include('common/script-del_check')
<script>
    window.addEventListener('load', function() {
        document.getElementById('search_user_id').addEventListener('change', function() {
          let requests = {
            user_id: this.value
          }
          let url = getRequestUrl(requests);
          if (!url) return;

          window.location.href = url;
          return;
        }, false);
        document.getElementById('search_start_at').addEventListener('change', function() {
          let requests = {
            start_at: this.value
          }
          let url = getRequestUrl(requests);
          if (!url) return;

          window.location.href = url;
          return;
        }, false);
    }, false);
</script>
@endsection