<div class="container-fluid px-0">
  <div class="row text-center mb-3">
    <div class="col">
      @if($target == 'store')
      <h1 class="h2">@lang('db.reports') @lang('db.report_partners') <br class="d-md-none" />@lang('system.title.create')</h1>
      @elseif($target == 'update')
      <h1 class="h2">@lang('db.reports') @lang('db.report_partners') <br class="d-md-none" />@lang('system.title.edit')</h1>
      @endif
    </div>
  </div>
  @if($target == 'store')
  <form action="/report/{{ $report->id }}/partner" method="post" onsubmit="return submitForm()">
  @elseif($target == 'update')
  <form action="/report/{{ $report->id }}/partner/{{ $report_partner->id }}" name="" method="post" onsubmit="return submitForm()">
    <input type="hidden" name="_method" value="PUT">
  @endif
    @csrf
    <div class="row justify-content-center">
      <div class="col-12 col-md-12 col-lg-12">{{-- Set Input Form Size --}}
        @include('common/error-message')
        @include('report/info', ['report' => $report])
        <div class="card border-secondary mb-3 w-100">
          <div class="card-header mb-2">@lang('db.report_partners') @lang('system.title.information')</div>
          <div class="card-body">
            <div class="container-fluid p-0 m-0">
              <div class="row">
                <div class="col-12 col-md-4">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report_partner.partner_id')</label>
                    <select id="partner_select" class="form-select @error('partner_id') is-invalid @enderror" name="partner_id">
                      <option value="" data-company_name="" data-quantity=""></option>
                      @foreach ($partners as $partner)
                      <option value="{{ $partner->id }}" data-company_name="{{ $partner->company_name }}" data-quantity="{{ $partner->quantity }}" @if(old('partner_id', $report_partner->partner_id)==$partner->id) selected  @endif>{{ $partner->name }}</option>
                      @endforeach
                    </select>
                    @error('partner_id')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                  </div>
                </div>
                <div class="col-12 col-md-4">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report_partner.company_name')</label>
                    @php
                      $old_company_name = '';
                      if ($target == 'update' && !empty($report_partner->partner_id)) {
                        $old_company_name = $report_partner->partner->company_name;
                      }
                    @endphp
                    <input type="text" id="partner_company_name" class="form-control" name="company_name" placeholder="" value="{{ old('company_name', $old_company_name) }}" readonly>
                  </div>
                </div>
                <div class="col-12 col-md-4">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report_partner.quantity')</label>
                    <div class="input-group @error('quantity') is-invalid @enderror">
                      <input type="number" id="partner_quantity" class="form-control @error('quantity') is-invalid @enderror" name="quantity" value="{{ old('quantity', $report_partner->quantity) }}">
                      <span class="input-group-text">@lang('system.unit.dai')</span>
                    </div>
                    @error('quantity')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-12 col-md-6">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report_partner.car_number')</label>
                    <input type="text" class="form-control @error('car_number') is-invalid @enderror" name="car_number" placeholder="" value="{{ old('car_number', $report_partner->car_number) }}">
                    @error('car_number')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                  </div>
                </div>
                <div class="col-12 col-md-6">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report_partner.item_name')</label>
                    <input type="text" class="form-control @error('item_name') is-invalid @enderror" name="item_name" placeholder="" value="{{ old('item_name', $report_partner->item_name) }}">
                    @error('item_name')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-12 col-md-6">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report_partner.count')</label>
                    <input type="number" class="form-control @error('count') is-invalid @enderror" name="count" placeholder="" value="{{ old('count', $report_partner->count) }}">
                    @error('count')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                  </div>
                </div>
                <div class="col-12 col-md-6">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report_partner.take_down')</label>
                    <input type="text" class="form-control @error('take_down') is-invalid @enderror" name="take_down" placeholder="" value="{{ old('take_down', $report_partner->take_down) }}">
                    @error('take_down')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="row justify-content-center mb-4">
      <div class="col-12 col-md-5 col-lg-4 mt-2 mb-2">{{-- Not Change --}}
        <button type="submit" id="submit-button" class="btn btn-primary w-100"><span class="bi bi-check-circle me-2"></span>@lang('system.command.register')</button>
      </div>
      <div class="col-12 col-md-3 col-lg-2 mt-2 mb-2">
        @if (session()->has('checkpoint-second'))
        <a href="{{ session()->get('checkpoint-second') }}" class="btn btn-outline-primary w-100"><span class="bi bi-caret-left me-1"></span>@lang('system.command.back')</a>
        @else
        <a href="./" class="btn btn-outline-primary w-100"><span class="bi bi-caret-left me-1"></span>@lang('system.command.back')</a>
        @endif
      </div>
    </div>
  </form>
</div>
@include('common/script-form')
<script>
    window.addEventListener('load', function() {
        document.getElementById('partner_select').addEventListener('change', function() {
          let partner_company_name = document.getElementById('partner_company_name');
          let partner_quantity = document.getElementById('partner_quantity');
          let i = this.selectedIndex;
          partner_company_name.value = this.options[i].dataset['company_name'];
          partner_quantity.value = this.options[i].dataset['quantity'];
          return;
        }, false);
    }, false);
</script>