<div class="container-fluid px-0">
  <div class="row text-center mb-3">
    <div class="col">
      @if($target == 'store')
      <h1 class="h2">@lang('db.reports') @lang('db.report_rests') <br class="d-md-none" />@lang('system.title.create')</h1>
      @elseif($target == 'update')
      <h1 class="h2">@lang('db.reports') @lang('db.report_rests') <br class="d-md-none" />@lang('system.title.edit')</h1>
      @endif
    </div>
  </div>
  @if($target == 'store')
  <form action="/report/{{ $report->id }}/rest" method="post" onsubmit="return submitForm()">
  @elseif($target == 'update')
  <form action="/report/{{ $report->id }}/rest/{{ $report_rest->id }}" name="" method="post" onsubmit="return submitForm()">
    <input type="hidden" name="_method" value="PUT">
  @endif
    @csrf
    <div class="row justify-content-center">
      <div class="col-12 col-md-12 col-lg-12">{{-- Set Input Form Size --}}
        @include('common/error-message')
        @include('report/info', ['report' => $report])
        <div class="card border-secondary mb-3 w-100">
          <div class="card-header mb-2">@lang('db.report_rests') @lang('system.title.information')</div>
          <div class="card-body">
            <div class="container-fluid p-0 m-0">
              <div class="row">
                <div class="col-12 col-md-6">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report_rest.point')</label>
                    <input type="text" class="form-control @error('point') is-invalid @enderror" name="point" placeholder="" value="{{ old('point', $report_rest->point) }}">
                    @error('point')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                  </div>
                </div>
                <div class="col-12 col-md-6">
                </div>
              </div>
              <div class="row">
                <div class="col-12 col-md-6">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report_rest.start_at')</label>
                    @php
                      $old_start_at = '';
                      if ($target == 'store') {
                        $old_start_at = date('Y-m-d\TH:i');
                      } else {
                        $old_start_at = date('Y-m-d\TH:i', strtotime($report_rest->start_at));
                      }
                    @endphp
                    <input type="datetime-local" class="form-control @error('start_at') is-invalid @enderror" name="start_at" placeholder="" value="{{ old('start_at', $old_start_at) }}">
                    @error('start_at')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                  </div>
                </div>
                <div class="col-12 col-md-6">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report.end_at')</label>
                    @php
                      $old_end_at = '';
                      if ($target == 'update' && !empty($report_rest->end_at)) {
                        $old_end_at = date('Y-m-d\TH:i', strtotime($report_rest->end_at));
                      }
                    @endphp
                    <input type="datetime-local" class="form-control @error('end_at') is-invalid @enderror" name="end_at" placeholder="" value="{{ old('end_at', $old_end_at) }}">
                    @error('end_at')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                    @if($target == 'store')
                    <div class="form-text">@lang('db.report.end_at')は後からでも入力できます</div>
                    @endif
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="row justify-content-center mb-4">
      <div class="col-12 col-md-5 col-lg-4 mt-2 mb-2">{{-- Not Change --}}
        <button type="submit" id="submit-button" class="btn btn-primary w-100"><span class="bi bi-check-circle me-2"></span>@lang('system.command.register')</button>
      </div>
      <div class="col-12 col-md-3 col-lg-2 mt-2 mb-2">
        @if (session()->has('checkpoint-second'))
        <a href="{{ session()->get('checkpoint-second') }}" class="btn btn-outline-primary w-100"><span class="bi bi-caret-left me-1"></span>@lang('system.command.back')</a>
        @else
        <a href="./" class="btn btn-outline-primary w-100"><span class="bi bi-caret-left me-1"></span>@lang('system.command.back')</a>
        @endif
      </div>
    </div>
  </form>
</div>
@include('common/script-form')
