@extends('common/main/layout')
@section('content')
<div class="container-fluid px-0">
  <div class="row mb-3">
    <div class="col">
      <h1 class="h2">@lang('db.reports') @lang('db.report_rests') @lang('system.title.index')</h1>
    </div>
  </div>
  <div class="row mb-3">
    <div class="col">
      @include('report/info', ['report' => $report])
    </div>
  </div>
  @include('common/error-message')
  <div class="row">
    <div class="col-12 col-md">
      <a href="/report/{{ $report->id }}/rest/create" class="btn btn-primary m-2"><span class="bi bi-plus-square me-2"></span>@lang('system.command.create')</a>
    </div>
    <div class="col-12 col-md text-md-end">
      <span class="position-relative d-inline-block m-2">
        <a href="/report/{{ $report->id }}/waypoint" class="btn btn-xs btn-info"><span class="bi bi-geo-alt-fill"></span></a>
        @if ($report->waypoints->count() > 0)
        <span class="badge rounded-pill bg-primary badge-from-btn">{{ $report->waypoints->count() }}</span>
        @endif
      </span>
      <span class="position-relative d-inline-block m-2">
        <a href="/report/{{ $report->id }}/partner" class="btn btn-xs btn-info"><span class="bi bi-people-fill"></span></a>
        @if ($report->partners->count() > 0)
        <span class="badge rounded-pill bg-primary badge-from-btn">{{ $report->partners->count() }}</span>
        @endif
      </span>
      <span class="position-relative d-inline-block m-2">
        <a href="/report/{{ $report->id }}/rest" class="btn btn-xs btn-info"><span class="bi bi-tree-fill"></span></a>
        @if ($report->rests->count() > 0)
        <span class="badge rounded-pill bg-primary badge-from-btn">{{ $report->rests->count() }}</span>
        @endif
      </span>
      @if (session()->has('checkpoint'))
      <a href="{{ session()->get('checkpoint') }}" class="btn btn-outline-primary ms-4"><span class="bi bi-caret-left me-1"></span>@lang('system.command.back')</a>
      @else
      <a href="../" class="btn btn-outline-primary ms-4"><span class="bi bi-caret-left me-1"></span>@lang('system.command.back')</a>
      @endif
    </div>
  </div>
  <div class="row">
    <div class="col">
      <div class="table-responsive">
        <table class="table table-hover text-nowrap">
          <thead>
            <tr>
              <th class="text-center tb-col-icon-button">@lang('system.command.edit')</th>
              <th class="text-start">@lang('db.report_rest.point')<span class="sort_button ms-2" data-sort="point"></span></th>
              <th class="text-start">@lang('db.report_rest.start_at')<span class="sort_button ms-2" data-sort="start_at"></span></th>
              <th class="text-start">@lang('db.report_rest.end_at')<span class="sort_button ms-2" data-sort="end_at"></span></th>
              <th class="text-center tb-col-icon-button">@lang('system.command.delete')</th>
            </tr>
          </thead>
          <tbody>
            @foreach($report_rests as $report_rest)
            <tr>
              <td class="text-center tb-col-icon-button">
                <a href="/report/{{ $report->id }}/rest/{{ $report_rest->id }}/edit" class="btn btn-xs btn-success"><span class="bi bi-pencil-fill"></span></a>
              </td>
              <td class="text-start">{{ $report_rest->point }}</td>
              <td class="text-start">@if(!empty($report_rest->start_at)){{ date('G時i分', strtotime($report_rest->start_at)) }}@endif</td>
              <td class="text-start">@if(!empty($report_rest->end_at)){{ date('G時i分', strtotime($report_rest->end_at)) }}@endif</td>
              <td class="text-center tb-col-icon-button">
                <form action="/report/{{ $report->id }}/rest/{{ $report_rest->id }}" method="post">
                  @csrf
                  <input type="hidden" name="_method" value="DELETE">
                  <button type="submit" class="btn btn-xs btn-outline-danger" aria-label="Left Align" onClick="del_check(event);"><span class="bi bi-trash3"></span></button>
                </form>
              </td>
            </tr>
            @endforeach
          </tbody>
        </table>
      </div>
    </div>
  </div>
  @include('common/pagination', ['tables' => $report_rests])
</div>
@include('common/script-del_check')
@endsection