<div class="container-fluid px-0">
  <div class="row text-center mb-3">
    <div class="col">
      @if($target == 'store')
      <h1 class="h2">@if(Route::is('report.*')) @lang('db.reports') @lang('db.report_waypoints') @endif @if(Route::is('work.*')) @lang('db.works') @endif <br class="d-md-none" />@lang('system.title.create')</h1>
      @elseif($target == 'update')
      <h1 class="h2">@if(Route::is('report.*')) @lang('db.reports') @lang('db.report_waypoints') @endif @if(Route::is('work.*')) @lang('db.works') @endif <br class="d-md-none" />@lang('system.title.edit')</h1>
      @elseif($target == 'emergency')
      <h1 class="h2">@lang('db.report_waypoint.emergency')</h1>
      @endif
    </div>
  </div>
  @if($target == 'store')
  <form action="/report/{{ $report->id }}/waypoint" method="post" onsubmit="return submitForm()">
  @elseif($target == 'emergency')
  <form action="/report/{{ $report->id }}/waypoint" method="post" onsubmit="return submitAndSendForm()">
  @elseif($target == 'update')
  <form action="/report/{{ $report->id }}/waypoint/{{ $report_waypoint->id }}" name="" method="post" onsubmit="return submitForm()">
    <input type="hidden" name="_method" value="PUT">
  @endif
    @csrf
    <div class="row justify-content-center">
      <div class="col-12 col-md-12 col-lg-12">{{-- Set Input Form Size --}}
        @include('common/error-message')
        @include('report/info', ['report' => $report])
        <div class="card @if($target == 'emergency') border-warning @else border-secondary @endif mb-3 w-100">
          <div class="card-header mb-2 @if($target == 'emergency') bg-warning bg-opacity-25 @endif">@if(Route::is('report.*')) @lang('db.reports') @lang('db.report_waypoints') @endif @if(Route::is('work.*') && $target !== 'emergency') @lang('db.works') @elseif($target == 'emergency') @lang('db.report_waypoint.emergency') @endif @lang('system.title.information')</div>
          <div class="card-body">
            <div class="container-fluid p-0 m-0">
              <div class="row">
                <div class="col-12 col-md-6">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report_waypoint.take_up')</label>
                    <input type="text" class="form-control @error('take_up') is-invalid @enderror" name="take_up" placeholder="" value="{{ old('take_up', $report_waypoint->take_up) }}">
                    @error('take_up')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                  </div>
                </div>
                <div class="col-12 col-md-6">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report_waypoint.take_down')</label>
                    <input type="text" class="form-control @error('take_down') is-invalid @enderror" name="take_down" placeholder="" value="{{ old('take_down', $report_waypoint->take_down) }}">
                    @error('take_down')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-12 col-md-12">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report_waypoint.address')</label>
                    <input type="text" class="form-control @error('address') is-invalid @enderror" name="address" placeholder="" value="{{ old('address', $report_waypoint->address) }}">
                    @error('address')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report_waypoint.item_name')</label>
                    <div class="container-fluid px-0">
                      <div class="row">
                        <div class="col-12 col-md-6">
                          <select id="item_select" class="form-select">
                            <option value=""></option>
                            @foreach ($items as $item)
                              <option value="{{ $item->name }}">{{ $item->name }}</option>
                            @endforeach
                          </select>
                          <div class="form-text">リストから選択または直接入力してください</div>
                        </div>
                        <div class="col-12 col-md-6">
                          <input type="text" id="item_name" class="form-control @error('item_name') is-invalid @enderror" name="item_name" placeholder="" value="{{ old('item_name', $report_waypoint->item_name) }}">
                          @error('item_name')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-12 col-md-6">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report_waypoint.quantity')</label>
                    <div class="container-fluid px-0">
                      <div class="row">
                        <div class="col-8 pe-1">
                          <input type="number" step="0.01" class="form-control @error('quantity') is-invalid @enderror" name="quantity" placeholder="" value="{{ old('quantity', $report_waypoint->quantity) }}">
                          @error('quantity')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                        </div>
                        <div class="col-4 ps-1">
                          <select class="form-select @error('unit') is-invalid @enderror" name="unit">
                            <option value=""></option>
                            @foreach (config('const.UNITS'); as $key => $value)
                              <option value="{{ $key }}" @if(old('unit', $report_waypoint->unit)==$key) selected  @endif>{{ $value }}</option>
                            @endforeach
                          </select>
                          @error('unit')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="col-12 col-md-4">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report_waypoint.unit_price')</label>
                    <div class="input-group @error('unit_price') is-invalid @enderror">
                    <span class="input-group-text">@lang('system.unit.yen-mark')</span>
                      <input type="number" class="form-control @error('unit_price') is-invalid @enderror" name="unit_price" value="{{ old('unit_price', $report_waypoint->unit_price) }}">
                    </div>
                    @error('unit_price')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                  </div>
                </div>
                <div class="col-12 col-md-2">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report_waypoint.type_id')</label>
                    <select class="form-select @error('type_id') is-invalid @enderror" name="type_id">
                      @foreach ($types as $type)
                      <option value="{{ $type->id }}" @if(old('type_id', $report_waypoint->type_id)==$type->id) selected  @endif>{{ $type->name }}</option>
                      @endforeach
                    </select>
                    @error('type_id')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-12 col-md-6">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report_waypoint.billing_id')</label>
                    <select class="form-select @error('billing_id') is-invalid @enderror" name="billing_id">
                      <option value=""></option>
                      @foreach ($billings as $billing)
                      <option value="{{ $billing->id }}" @if(old('billing_id', $report_waypoint->billing_id)==$billing->id) selected  @endif>{{ $billing->name }}</option>
                      @endforeach
                    </select>
                    @error('billing_id')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                  </div>
                </div>
                <div class="col-12 col-md-6">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report_waypoint.billing_disposal_name')</label>
                    <input type="text" class="form-control @error('billing_disposal_name') is-invalid @enderror" name="billing_disposal_name" placeholder="" value="{{ old('billing_disposal_name', $report_waypoint->billing_disposal_name) }}">
                    @error('billing_disposal_name')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-12 col-md-6">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report_waypoint.highway_money')</label>
                    <div class="container-fluid px-0">
                      <div class="row">
                        <div class="col-8 pe-1">
                          <div class="input-group @error('highway_money') is-invalid @enderror">
                            <span class="input-group-text">@lang('system.unit.yen-mark')</span>
                            <input type="number" class="form-control @error('highway_money') is-invalid @enderror" name="highway_money" placeholder="" value="{{ old('highway_money', $report_waypoint->highway_money) }}">
                          </div>
                          @error('highway_money')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                          <span class="invalid-feedback" role="alert"><strong>unyaaaaa</strong></span>
                        </div>
                        <div class="col-4 ps-1">
                          <select class="form-select @error('highway_payment') is-invalid @enderror" name="highway_payment">
                            <option value=""></option>
                            @foreach (config('const.PAYMENTS'); as $key => $value)
                              <option value="{{ $key }}" @if(old('highway_payment', $report_waypoint->highway_payment)==$key) selected  @endif>{{ $value }}</option>
                            @endforeach
                          </select>
                          @error('highway_payment')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="col-12 col-md-6">
                  <div class="form-group mb-4">
                  @if($target == 'store')
                  @elseif($target == 'emergency')
                    <label class="form-label mb-2">@lang('db.report_waypoint.emergency')</label>
                    <input type="hidden" name="emergency" value="1">
                    <div class="form-text">この経路を緊急配車に指定します。一覧に<span class="bi bi-info-circle-fill mx-1 text-warning"></span>アイコンが付き、運転者にメールが送信され、ダッシュボードで強調表示されます。</div>
                  @elseif($target == 'update' && $report_waypoint->emergency == '1')
                    <input type="hidden" name="emergency" value="1">
                    <!-- <label class="form-label mb-2">@lang('db.report_waypoint.emergency')</label>
                    <div class="form-check @error('emergency') is-invalid @enderror">
                      <label class="form-check-label">
                        <input type="checkbox" class="form-check-input @error('emergency') is-invalid @enderror" name="emergency" value="1" @if(old('emergency', $report_waypoint->emergency)=='1') checked  @endif>
                        @lang('db.report_waypoint.emergency-1')
                      </label>
                      <div class="form-text">緊急の場合は一覧に<span class="bi bi-info-circle-fill mx-1 text-warning"></span>アイコンが付き、ダッシュボードで強調表示されます。</div>
                    </div>
                    @error('emergency')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror -->
                  @endif
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-12 col-md-12">
                  <div class="form-group mb-4">
                    <label class="form-label mb-2">@lang('db.report_waypoint.note')</label>
                    <textarea class="form-control @error('note') is-invalid @enderror" id="exampleTextarea" rows="5" name="note">{{ old('note', $report_waypoint->note) }}</textarea>
                    @error('note')<span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>@enderror
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="row justify-content-center mb-4">
      <div class="col-12 col-md-5 col-lg-4 mt-2 mb-2">{{-- Not Change --}}
        @if($target == 'emergency')
        <button type="submit" id="submit-button" class="btn btn-primary w-100">
          <span id="submit-icon" class="bi bi-send me-1"></span>
          <span id="spinner-icon" class="spinner-border spinner-border-sm me-1 d-none" role="status" aria-hidden="true"></span>
          <span id="submit-text">保存してメールを送信する</span>
        </button>
        @else
        <button type="submit" id="submit-button" class="btn btn-primary w-100"><span class="bi bi-check-circle me-2"></span>@lang('system.command.register')</button>
        @endif
      </div>
      <div class="col-12 col-md-3 col-lg-2 mt-2 mb-2">
        @if (session()->has('checkpoint-second'))
        <a href="{{ session()->get('checkpoint-second') }}" class="btn btn-outline-primary w-100"><span class="bi bi-caret-left me-1"></span>@lang('system.command.back')</a>
        @else
        <a href="./" class="btn btn-outline-primary w-100"><span class="bi bi-caret-left me-1"></span>@lang('system.command.back')</a>
        @endif
      </div>
    </div>
  </form>
</div>
@include('common/script-form')
<script>
    window.addEventListener('load', function() {
        document.getElementById('item_select').addEventListener('change', function() {
          let item_name = document.getElementById('item_name');
          item_name.value = this.value;
          return;
        }, false);
    }, false);

  function submitAndSendForm() {
    document.getElementById('submit-button').style.pointerEvents = 'none';
    document.getElementById('submit-icon').classList.add("d-none");
    document.getElementById('spinner-icon').classList.remove("d-none");
    document.getElementById('submit-text').innerText = 'メール送信中...';
  }
</script>