@extends('common/main/layout')
@section('content')
<div class="container-fluid px-0">
  <div class="row mb-3">
    <div class="col">
      <h1 class="h2">@if(Route::is('report.*')) @lang('db.reports') @lang('db.report_waypoints') @endif @if(Route::is('work.*')) @lang('db.works') @endif @lang('system.title.index')</h1>
    </div>
  </div>
  <div class="row mb-3">
    <div class="col">
      @include('report/info', ['report' => $report])
    </div>
  </div>
  @include('common/error-message')
  <div class="row">
    <div class="col-12 col-md">
      <a href="./waypoint/create" class="btn btn-primary m-2"><span class="bi bi-plus-square me-2"></span>@lang('system.command.create')</a>
      {{-- ◆◆◆検査対応 @if(Route::is('work.*'))
      <a href="./waypoint/emergency" class="btn btn-warning m-2 fw-bold"><span class="bi bi-info-circle-fill me-2"></span>@lang('db.report_waypoint.emergency')</a>
      @endif --}}
    </div>
    <div class="col-12 col-md text-md-end">
    @if(Route::is('report.*'))
      <span class="position-relative d-inline-block m-2">
        <a href="/report/{{ $report->id }}/waypoint" class="btn btn-xs btn-info"><span class="bi bi-geo-alt-fill"></span></a>
        @if ($report->waypoints->count() > 0)
        <span class="badge rounded-pill bg-primary badge-from-btn">{{ $report->waypoints->count() }}</span>
        @endif
      </span>
      <span class="position-relative d-inline-block m-2">
        <a href="/report/{{ $report->id }}/partner" class="btn btn-xs btn-info"><span class="bi bi-people-fill"></span></a>
        @if ($report->partners->count() > 0)
        <span class="badge rounded-pill bg-primary badge-from-btn">{{ $report->partners->count() }}</span>
        @endif
      </span>
      <span class="position-relative d-inline-block m-2">
        <a href="/report/{{ $report->id }}/rest" class="btn btn-xs btn-info"><span class="bi bi-tree-fill"></span></a>
        @if ($report->rests->count() > 0)
        <span class="badge rounded-pill bg-primary badge-from-btn">{{ $report->rests->count() }}</span>
        @endif
      </span>
    @endif
      @if (session()->has('checkpoint'))
      <a href="{{ session()->get('checkpoint') }}" class="btn btn-outline-primary ms-4"><span class="bi bi-caret-left me-1"></span>@lang('system.command.back')</a>
      @else
      <a href="../" class="btn btn-outline-primary ms-4"><span class="bi bi-caret-left me-1"></span>@lang('system.command.back')</a>
      @endif
    </div>
  </div>
  <div class="row">
    <div class="col">
      <div class="table-responsive">
        <table class="table table-hover text-nowrap">
          <thead>
            <tr>
              <th class="text-center tb-col-icon-button">@lang('system.command.edit')</th>
              <th class="text-start">@lang('db.report_waypoint.take_up')<span class="sort_button ms-2" data-sort="take_up"></span></th>
              <th class="text-start">@lang('db.report_waypoint.take_down')<span class="sort_button ms-2" data-sort="take_down"></span></th>
              <th class="text-start">@lang('db.report_waypoint.address')<span class="sort_button ms-2" data-sort="address"></span></th>
              <th class="text-start">@lang('db.report_waypoint.item_name')<span class="sort_button ms-2" data-sort="item_name"></span></th>
              <th class="text-end">@lang('db.report_waypoint.quantity')<span class="sort_button ms-2" data-sort="quantity"></span></th>
              <th class="text-end">@lang('db.report_waypoint.unit_price')<span class="sort_button ms-2" data-sort="unit_price"></span></th>
              <th class="text-start">@lang('db.report_waypoint.type_id')<span class="sort_button ms-2" data-sort="type_id"></span></th>
              <th class="text-start">@lang('db.report_waypoint.billing_id')<span class="sort_button ms-2" data-sort="billing_id"></span></th>
              <th class="text-start">@lang('db.report_waypoint.billing_disposal_name')<span class="sort_button ms-2" data-sort="billing_disposal_name"></span></th>
              <th class="text-end">@lang('db.report_waypoint.highway_money')<span class="sort_button ms-2" data-sort="highway_money"></span></th>
              <th class="text-start">@lang('db.report_waypoint.note')<span class="sort_button ms-2" data-sort="note"></span></th>
              <th class="text-center tb-col-icon-button">@lang('system.command.delete')</th>
            </tr>
          </thead>
          <tbody>
            @foreach($report_waypoints as $report_waypoint)
            <tr>
              <td class="text-center tb-col-icon-button">
                <a href="./waypoint/{{ $report_waypoint->id }}/edit" class="btn btn-xs btn-success"><span class="bi bi-pencil-fill"></span></a>
              </td>
              <td class="text-start">@if(!empty($report_waypoint->emergency))<span class="bi bi-info-circle-fill me-1 text-warning"></span>@endif{{ $report_waypoint->take_up }}</td>
              <td class="text-start">{{ $report_waypoint->take_down }}</td>
              <td class="text-start">{{ $report_waypoint->address }}</td>
              <td class="text-start">{{ $report_waypoint->item_name }}</td>
              <td class="text-end">@if(!empty($report_waypoint->quantity)){{ number_format($report_waypoint->quantity, 2) }}@if(!empty($report_waypoint->unit))&nbsp;{{ config('const.UNITS.'.$report_waypoint->unit) }}@endif @endif</td>
              <td class="text-end">@if(!empty($report_waypoint->unit_price))@lang('system.unit.yen-mark'){{ number_format($report_waypoint->unit_price) }}@endif</td>
              <td class="text-start">{{ $report_waypoint->type->name }}</td>
              <td class="text-start">@if(!empty($report_waypoint->billing_id)){{ $report_waypoint->billing->name }}@endif</td>
              <td class="text-start">{{ $report_waypoint->billing_disposal_name }}</td>
              <td class="text-end">@if(!empty($report_waypoint->highway_money))@lang('system.unit.yen-mark'){{ number_format($report_waypoint->highway_money) }}@if($report_waypoint->highway_money > 0 && !empty($report_waypoint->highway_payment))&nbsp;&#40;{{ config('const.PAYMENTS.'.$report_waypoint->highway_payment) }}&#41;@endif @endif</td>
              <td class="text-start"><span data-bs-toggle="tooltip" data-bs-placement="right" data-html="true" title="{{ $report_waypoint->note }}">{{ Str::limit($report_waypoint->note, 50) }}</span></td>
              <td class="text-center tb-col-icon-button">
                <form action="./waypoint/{{ $report_waypoint->id }}" method="post">
                  @csrf
                  <input type="hidden" name="_method" value="DELETE">
                  <button type="submit" class="btn btn-xs btn-outline-danger" aria-label="Left Align" onClick="del_check(event);"><span class="bi bi-trash3"></span></button>
                </form>
              </td>
            </tr>
            @endforeach
          </tbody>
        </table>
      </div>
    </div>
  </div>
  @include('common/pagination', ['tables' => $report_waypoints])
</div>
@include('common/script-del_check')
<script>
  let tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
  let tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
    return new bootstrap.Tooltip(tooltipTriggerEl);
  });
</script>
@endsection