@extends('common/main/layout')
@section('content')
<div class="container-fluid px-0">
  <div class="row mb-3">
    <div class="col">
      <h1 class="h2">@lang('db.reports') @lang('db.report.oil')@lang('system.title.total')</h1>
    </div>
  </div>
  @include('common/error-message')
  <div class="row">
    <div class="d-none d-md-block col-12 col-md">
    </div>
    <div class="col col-md p-2">
      <select id="search_user_id" class="form-select" name="user_id">
        <option value="all">すべて表示</option>
        @foreach ($users as $user)
          <option value="{{ $user->id }}" @if($params['user_id'] == $user->id) selected  @endif>{{ $user->name }}</option>
        @endforeach
      </select>
    </div>
    <div class="col-12 col-md p-2">
      <input type="month" id="search_start_at" class="form-control" name="start_at" placeholder="" value="{{ old('start_at', date('Y-m', strtotime($params['start_at']))) }}">
    </div>
  </div>
  <div class="row">
    <div class="col">
      <div class="table-responsive">
        <table class="table table-hover text-nowrap">
          <thead>
            <tr>
              <th class="text-start">日付</th>
              <th class="text-end">@lang('db.report.light_oil')<span class="sort_button ms-2" data-sort="light_oil"></span></th>
              <th class="text-end">@lang('db.report.adblue')<span class="sort_button ms-2" data-sort="adblue"></span></th>
              <th class="text-end">@lang('db.report.adblue_handy')<span class="sort_button ms-2" data-sort="adblue_handy"></span></th>
            </tr>
          </thead>
          <tbody>
            @php
              $sumArray['light_oil'] = 0;
              $sumArray['adblue'] = 0;
              $sumArray['adblue_handy'] = 0;
            @endphp
            @foreach($totals as $total)
            <tr>
              <td class="text-start">
                {{ date('j日', strtotime($total->date)) }}
              </td>
              <td class="text-end">
                @if (!empty($total->sum_light_oil))
                  {{ number_format($total->sum_light_oil) }}&nbsp;@lang('system.unit.liter')
                  @php $sumArray['light_oil'] = $sumArray['light_oil'] + intval($total->sum_light_oil); @endphp
                @else
                  -
                @endif
              </td>
              <td class="text-end">
                @if (!empty($total->sum_adblue))
                  {{ number_format($total->sum_adblue) }}&nbsp;@lang('system.unit.liter')
                  @php $sumArray['adblue'] = $sumArray['adblue'] + intval($total->sum_adblue); @endphp
                @else
                  -
                @endif
              </td>
              <td class="text-end">
                @if (!empty($total->sum_adblue_handy))
                  {{ number_format($total->sum_adblue_handy) }}&nbsp;@lang('system.unit.ko')
                  @php $sumArray['adblue_handy'] = $sumArray['adblue_handy'] + intval($total->sum_adblue_handy); @endphp
                @else
                  -
                @endif
              </td>
            </tr>
            @endforeach
            <tr class="table-light">
              <td class="text-center fw-bold">
                合計
              </td>
              <td class="text-end fw-bold">
                {{ number_format($sumArray['light_oil']) }}&nbsp;@lang('system.unit.liter')
              </td>
              <td class="text-end fw-bold">
                {{ number_format($sumArray['adblue']) }}&nbsp;@lang('system.unit.liter')
              </td>
              <td class="text-end fw-bold">
                {{ number_format($sumArray['adblue_handy']) }}&nbsp;@lang('system.unit.ko')
              </td>
            </tr>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
<script>
    window.addEventListener('load', function() {
        document.getElementById('search_user_id').addEventListener('change', function() {
          let requests = {
            user_id: this.value
          }
          let url = getRequestUrl(requests);
          if (!url) return;

          window.location.href = url;
          return;
        }, false);
        document.getElementById('search_start_at').addEventListener('change', function() {
          let requests = {
            start_at: this.value
          }
          let url = getRequestUrl(requests);
          if (!url) return;

          window.location.href = url;
          return;
        }, false);
    }, false);
</script>
@endsection