@extends('common/main/layout')
@section('content')
<div class="container-fluid px-0">
  <div class="row mb-3">
    <div class="col">
      <h1 class="h2">
      @if(Route::is('work.index'))
        @lang('db.works')
      @endif
      @if(Route::is('emergency.index'))
        @lang('db.report_waypoint.emergency')
      @endif
      </h1>
    </div>
  </div>
  @include('common/error-message')
  @include('common/email-message')
  <div class="row">
    <div class="col-12 col-md">
      <a href="/report/create?start_at={{ date('Y-m-d', strtotime($params['start_at'])) }}" class="btn btn-primary m-2"><span class="bi bi-plus-square me-2"></span>@lang('db.reports')@lang('system.command.create')</a>
    </div>
    <div class="col col-md p-2">
    </div>
    <div class="col col-md p-2">
    </div>
    <div class="col-12 col-md p-2">
      <input type="date" id="search_start_at" class="form-control" name="start_at" placeholder="" value="{{ old('start_at', date('Y-m-d', strtotime($params['start_at']))) }}">
    </div>
  </div>
  <div class="row">
    <div class="col-12 col-md">
      <span class="m-2 text-primary">配車を行う運転日報を選択してください。対象の運転日報がまだ無い場合は上のボタンから作成してください。</span>
    </div>
  </div>
  <div class="row">
    <div class="col">
      <div class="table-responsive">
        <table class="table table-hover text-nowrap">
          <thead>
            <tr>
              <!-- <th class="text-center tb-col-icon-button">@lang('system.command.edit')</th> -->
              <th class="text-start">@lang('db.reports') 日付</th>
              <th class="text-start">@lang('db.reports') @lang('db.report.user_id')</th>
              <th class="text-start">@lang('db.reports') @lang('db.report.car_id')</th>
              @if(Route::is('work.index'))<th class="text-center tb-col-icon-button">@lang('db.works')@endif</th>
              @if(Route::is('emergency.index'))<th class="text-center tb-col-icon-button">@lang('db.report_waypoint.emergency')@endif</th>
              <th class="text-center tb-col-icon-button">@lang('db.reports')@lang('system.command.show')</th>
              <!-- <th class="text-center tb-col-icon-button">@lang('system.command.delete')</th> -->
            </tr>
          </thead>
          <tbody>
            @foreach($reports as $report)
            <tr>
              <!-- <td class="text-center tb-col-icon-button">
                <a href="/report/{{ $report->id }}/edit" class="btn btn-xs btn-success"><span class="bi bi-pencil-fill"></span></a>
              </td> -->
              <td class="text-start">{{ date('Y年n月j日', strtotime($report->start_at)) }}</td>
              <td class="text-start">{{ $report->user->name }}</td>
              <td class="text-start">{{ $report->car->number }}</td>
              @if(Route::is('work.index'))
              <td class="text-center tb-col-icon-button">
                <div class="position-relative">
                  <a href="/work/{{ $report->id }}/waypoint" class="btn btn-xs btn-info"><span class="bi bi-calendar3"></span></a>
                  @if ($report->waypoints->count() > 0)
                  <span class="badge rounded-pill bg-primary badge-from-btn">{{ $report->waypoints->count() }}</span>
                  @endif
                </div>
              </td>
              @endif
              @if(Route::is('emergency.index'))
              <td class="text-center tb-col-icon-button">
                <div class="position-relative">
                  <a href="/work/{{ $report->id }}/waypoint/emergency" class="btn btn-xs btn-warning fw-bold"><span class="bi bi-info-circle-fill me-2"></span>@lang('db.report_waypoint.emergency')</a>
                </div>
              </td>
              @endif
              <td class="text-center tb-col-icon-button">
                <a href="/report/{{ $report->id }}" class="btn btn-xs btn-primary"><span class="bi bi-stickies-fill"></span></a>
              </td>
              <!-- <td class="text-center tb-col-icon-button">
                <form action="/report/{{ $report->id }}" method="post">
                  @csrf
                  <input type="hidden" name="_method" value="DELETE">
                  <button type="submit" class="btn btn-xs btn-outline-danger" aria-label="Left Align" onClick="del_check(event);"><span class="bi bi-trash3"></span></button>
                </form>
              </td> -->
            </tr>
            @endforeach
          </tbody>
        </table>
      </div>
    </div>
  </div>
  @include('common/pagination', ['tables' => $reports])
</div>
@include('common/script-del_check')
<script>
    window.addEventListener('load', function() {
        document.getElementById('search_start_at').addEventListener('change', function() {
          let requests = {
            start_at: this.value
          }
          let url = getRequestUrl(requests);
          if (!url) return;

          window.location.href = url;
          return;
        }, false);
    }, false);
</script>
@endsection